/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceFilterAttribute {
    ARN("ARN"),
    PLATFORM("PLATFORM"),
    OS_VERSION("OS_VERSION"),
    MODEL("MODEL"),
    AVAILABILITY("AVAILABILITY"),
    FORM_FACTOR("FORM_FACTOR"),
    MANUFACTURER("MANUFACTURER"),
    REMOTE_ACCESS_ENABLED("REMOTE_ACCESS_ENABLED"),
    REMOTE_DEBUG_ENABLED("REMOTE_DEBUG_ENABLED"),
    INSTANCE_ARN("INSTANCE_ARN"),
    INSTANCE_LABELS("INSTANCE_LABELS"),
    FLEET_TYPE("FLEET_TYPE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceFilterAttribute> VALUE_MAP;
    private final String value;

    private DeviceFilterAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceFilterAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceFilterAttribute> knownValues() {
        EnumSet<DeviceFilterAttribute> knownValues = EnumSet.allOf(DeviceFilterAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceFilterAttribute.class, DeviceFilterAttribute::toString);
    }
}

