/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionResult {
    PENDING("PENDING"),
    PASSED("PASSED"),
    WARNED("WARNED"),
    FAILED("FAILED"),
    SKIPPED("SKIPPED"),
    ERRORED("ERRORED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionResult> VALUE_MAP;
    private final String value;

    private ExecutionResult(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionResult fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionResult> knownValues() {
        EnumSet<ExecutionResult> knownValues = EnumSet.allOf(ExecutionResult.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionResult.class, ExecutionResult::toString);
    }
}

