/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;

public class ListTestsPublisher
implements SdkPublisher<ListTestsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListTestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestsPublisher(DeviceFarmAsyncClient client, ListTestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestsPublisher(DeviceFarmAsyncClient client, ListTestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Test> tests() {
        Function<ListTestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tests() != null) {
                return response.tests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestsResponseFetcher
    implements AsyncPageFetcher<ListTestsResponse> {
        private ListTestsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestsResponse> nextPage(ListTestsResponse previousPage) {
            if (previousPage == null) {
                return ListTestsPublisher.this.client.listTests(ListTestsPublisher.this.firstRequest);
            }
            return ListTestsPublisher.this.client.listTests((ListTestsRequest)((Object)ListTestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

