/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;

public class ListTestsIterable
implements SdkIterable<ListTestsResponse> {
    private final DeviceFarmClient client;
    private final ListTestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestsIterable(DeviceFarmClient client, ListTestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestsResponseFetcher();
    }

    public Iterator<ListTestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Test> tests() {
        Function<ListTestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tests() != null) {
                return response.tests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestsResponseFetcher
    implements SyncPageFetcher<ListTestsResponse> {
        private ListTestsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestsResponse nextPage(ListTestsResponse previousPage) {
            if (previousPage == null) {
                return ListTestsIterable.this.client.listTests(ListTestsIterable.this.firstRequest);
            }
            return ListTestsIterable.this.client.listTests((ListTestsRequest)((Object)ListTestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

