/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionStatus {
    PENDING("PENDING"),
    PENDING_CONCURRENCY("PENDING_CONCURRENCY"),
    PENDING_DEVICE("PENDING_DEVICE"),
    PROCESSING("PROCESSING"),
    SCHEDULING("SCHEDULING"),
    PREPARING("PREPARING"),
    RUNNING("RUNNING"),
    COMPLETED("COMPLETED"),
    STOPPING("STOPPING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionStatus> VALUE_MAP;
    private final String value;

    private ExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionStatus> knownValues() {
        EnumSet<ExecutionStatus> knownValues = EnumSet.allOf(ExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionStatus.class, ExecutionStatus::toString);
    }
}

