/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceAvailability {
    TEMPORARY_NOT_AVAILABLE("TEMPORARY_NOT_AVAILABLE"),
    BUSY("BUSY"),
    AVAILABLE("AVAILABLE"),
    HIGHLY_AVAILABLE("HIGHLY_AVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceAvailability> VALUE_MAP;
    private final String value;

    private DeviceAvailability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceAvailability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceAvailability> knownValues() {
        EnumSet<DeviceAvailability> knownValues = EnumSet.allOf(DeviceAvailability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceAvailability.class, DeviceAvailability::toString);
    }
}

