/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of one or more problems, grouped by their result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UniqueProblem implements SdkPojo, Serializable, ToCopyableBuilder<UniqueProblem.Builder, UniqueProblem> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(UniqueProblem::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<List<Problem>> PROBLEMS_FIELD = SdkField
            .<List<Problem>> builder(MarshallingType.LIST)
            .memberName("problems")
            .getter(getter(UniqueProblem::problems))
            .setter(setter(Builder::problems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("problems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Problem> builder(MarshallingType.SDK_POJO)
                                            .constructor(Problem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MESSAGE_FIELD, PROBLEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final List<Problem> problems;

    private UniqueProblem(BuilderImpl builder) {
        this.message = builder.message;
        this.problems = builder.problems;
    }

    /**
     * <p>
     * A message about the unique problems' result.
     * </p>
     * 
     * @return A message about the unique problems' result.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Problems property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProblems() {
        return problems != null && !(problems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the problems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProblems} method.
     * </p>
     * 
     * @return Information about the problems.
     */
    public final List<Problem> problems() {
        return problems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasProblems() ? problems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueProblem)) {
            return false;
        }
        UniqueProblem other = (UniqueProblem) obj;
        return Objects.equals(message(), other.message()) && hasProblems() == other.hasProblems()
                && Objects.equals(problems(), other.problems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UniqueProblem").add("Message", message()).add("Problems", hasProblems() ? problems() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "problems":
            return Optional.ofNullable(clazz.cast(problems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UniqueProblem, T> g) {
        return obj -> g.apply((UniqueProblem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UniqueProblem> {
        /**
         * <p>
         * A message about the unique problems' result.
         * </p>
         * 
         * @param message
         *        A message about the unique problems' result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * 
         * @param problems
         *        Information about the problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problems(Collection<Problem> problems);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * 
         * @param problems
         *        Information about the problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problems(Problem... problems);

        /**
         * <p>
         * Information about the problems.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devicefarm.model.Problem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.devicefarm.model.Problem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devicefarm.model.Problem.Builder#build()} is called immediately and
         * its result is passed to {@link #problems(List<Problem>)}.
         * 
         * @param problems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devicefarm.model.Problem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #problems(java.util.Collection<Problem>)
         */
        Builder problems(Consumer<Problem.Builder>... problems);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private List<Problem> problems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UniqueProblem model) {
            message(model.message);
            problems(model.problems);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Problem.Builder> getProblems() {
            List<Problem.Builder> result = ProblemsCopier.copyToBuilder(this.problems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProblems(Collection<Problem.BuilderImpl> problems) {
            this.problems = ProblemsCopier.copyFromBuilder(problems);
        }

        @Override
        public final Builder problems(Collection<Problem> problems) {
            this.problems = ProblemsCopier.copy(problems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Problem... problems) {
            problems(Arrays.asList(problems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder problems(Consumer<Problem.Builder>... problems) {
            problems(Stream.of(problems).map(c -> Problem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UniqueProblem build() {
            return new UniqueProblem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
