/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfferingStatus implements SdkPojo, Serializable, ToCopyableBuilder<OfferingStatus.Builder, OfferingStatus> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(OfferingStatus::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Offering> OFFERING_FIELD = SdkField.<Offering> builder(MarshallingType.SDK_POJO)
            .memberName("offering").getter(getter(OfferingStatus::offering)).setter(setter(Builder::offering))
            .constructor(Offering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offering").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("quantity").getter(getter(OfferingStatus::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()).build();

    private static final SdkField<Instant> EFFECTIVE_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveOn").getter(getter(OfferingStatus::effectiveOn)).setter(setter(Builder::effectiveOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, OFFERING_FIELD,
            QUANTITY_FIELD, EFFECTIVE_ON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Offering offering;

    private final Integer quantity;

    private final Instant effectiveOn;

    private OfferingStatus(BuilderImpl builder) {
        this.type = builder.type;
        this.offering = builder.offering;
        this.quantity = builder.quantity;
        this.effectiveOn = builder.effectiveOn;
    }

    /**
     * <p>
     * The type specified for the offering status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingTransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type specified for the offering status.
     * @see OfferingTransactionType
     */
    public final OfferingTransactionType type() {
        return OfferingTransactionType.fromValue(type);
    }

    /**
     * <p>
     * The type specified for the offering status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OfferingTransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type specified for the offering status.
     * @see OfferingTransactionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Represents the metadata of an offering status.
     * </p>
     * 
     * @return Represents the metadata of an offering status.
     */
    public final Offering offering() {
        return offering;
    }

    /**
     * <p>
     * The number of available devices in the offering.
     * </p>
     * 
     * @return The number of available devices in the offering.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The date on which the offering is effective.
     * </p>
     * 
     * @return The date on which the offering is effective.
     */
    public final Instant effectiveOn() {
        return effectiveOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offering());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingStatus)) {
            return false;
        }
        OfferingStatus other = (OfferingStatus) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(offering(), other.offering())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(effectiveOn(), other.effectiveOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfferingStatus").add("Type", typeAsString()).add("Offering", offering())
                .add("Quantity", quantity()).add("EffectiveOn", effectiveOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "offering":
            return Optional.ofNullable(clazz.cast(offering()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "effectiveOn":
            return Optional.ofNullable(clazz.cast(effectiveOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferingStatus, T> g) {
        return obj -> g.apply((OfferingStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfferingStatus> {
        /**
         * <p>
         * The type specified for the offering status.
         * </p>
         * 
         * @param type
         *        The type specified for the offering status.
         * @see OfferingTransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTransactionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type specified for the offering status.
         * </p>
         * 
         * @param type
         *        The type specified for the offering status.
         * @see OfferingTransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTransactionType
         */
        Builder type(OfferingTransactionType type);

        /**
         * <p>
         * Represents the metadata of an offering status.
         * </p>
         * 
         * @param offering
         *        Represents the metadata of an offering status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offering(Offering offering);

        /**
         * <p>
         * Represents the metadata of an offering status.
         * </p>
         * This is a convenience method that creates an instance of the {@link Offering.Builder} avoiding the need to
         * create one manually via {@link Offering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Offering.Builder#build()} is called immediately and its result is
         * passed to {@link #offering(Offering)}.
         * 
         * @param offering
         *        a consumer that will call methods on {@link Offering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offering(Offering)
         */
        default Builder offering(Consumer<Offering.Builder> offering) {
            return offering(Offering.builder().applyMutation(offering).build());
        }

        /**
         * <p>
         * The number of available devices in the offering.
         * </p>
         * 
         * @param quantity
         *        The number of available devices in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The date on which the offering is effective.
         * </p>
         * 
         * @param effectiveOn
         *        The date on which the offering is effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveOn(Instant effectiveOn);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Offering offering;

        private Integer quantity;

        private Instant effectiveOn;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingStatus model) {
            type(model.type);
            offering(model.offering);
            quantity(model.quantity);
            effectiveOn(model.effectiveOn);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingTransactionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Offering.Builder getOffering() {
            return offering != null ? offering.toBuilder() : null;
        }

        public final void setOffering(Offering.BuilderImpl offering) {
            this.offering = offering != null ? offering.build() : null;
        }

        @Override
        public final Builder offering(Offering offering) {
            this.offering = offering;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final Instant getEffectiveOn() {
            return effectiveOn;
        }

        public final void setEffectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        @Override
        public final Builder effectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        @Override
        public OfferingStatus build() {
            return new OfferingStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
