/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on data source packages for members of the behavior graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipDatasources implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipDatasources.Builder, MembershipDatasources> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MembershipDatasources::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(MembershipDatasources::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<Map<String, Map<String, TimestampForCollection>>> DATASOURCE_PACKAGE_INGEST_HISTORY_FIELD = SdkField
            .<Map<String, Map<String, TimestampForCollection>>> builder(MarshallingType.MAP)
            .memberName("DatasourcePackageIngestHistory")
            .getter(getter(MembershipDatasources::datasourcePackageIngestHistoryAsStrings))
            .setter(setter(Builder::datasourcePackageIngestHistoryWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackageIngestHistory")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, TimestampForCollection>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<TimestampForCollection> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(TimestampForCollection::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            GRAPH_ARN_FIELD, DATASOURCE_PACKAGE_INGEST_HISTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String graphArn;

    private final Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory;

    private MembershipDatasources(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.graphArn = builder.graphArn;
        this.datasourcePackageIngestHistory = builder.datasourcePackageIngestHistory;
    }

    /**
     * <p>
     * The account identifier of the Amazon Web Services account.
     * </p>
     * 
     * @return The account identifier of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the organization behavior graph.
     * </p>
     * 
     * @return The ARN of the organization behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * Details on when a data source package was added to a behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackageIngestHistory} method.
     * </p>
     * 
     * @return Details on when a data source package was added to a behavior graph.
     */
    public final Map<DatasourcePackage, Map<DatasourcePackageIngestState, TimestampForCollection>> datasourcePackageIngestHistory() {
        return DatasourcePackageIngestHistoryCopier.copyStringToEnum(datasourcePackageIngestHistory);
    }

    /**
     * For responses, this returns true if the service returned a value for the DatasourcePackageIngestHistory property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDatasourcePackageIngestHistory() {
        return datasourcePackageIngestHistory != null && !(datasourcePackageIngestHistory instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Details on when a data source package was added to a behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatasourcePackageIngestHistory} method.
     * </p>
     * 
     * @return Details on when a data source package was added to a behavior graph.
     */
    public final Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistoryAsStrings() {
        return datasourcePackageIngestHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDatasourcePackageIngestHistory() ? datasourcePackageIngestHistoryAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipDatasources)) {
            return false;
        }
        MembershipDatasources other = (MembershipDatasources) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(graphArn(), other.graphArn())
                && hasDatasourcePackageIngestHistory() == other.hasDatasourcePackageIngestHistory()
                && Objects.equals(datasourcePackageIngestHistoryAsStrings(), other.datasourcePackageIngestHistoryAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MembershipDatasources")
                .add("AccountId", accountId())
                .add("GraphArn", graphArn())
                .add("DatasourcePackageIngestHistory",
                        hasDatasourcePackageIngestHistory() ? datasourcePackageIngestHistoryAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "DatasourcePackageIngestHistory":
            return Optional.ofNullable(clazz.cast(datasourcePackageIngestHistoryAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MembershipDatasources, T> g) {
        return obj -> g.apply((MembershipDatasources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipDatasources> {
        /**
         * <p>
         * The account identifier of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The account identifier of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the organization behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the organization behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * Details on when a data source package was added to a behavior graph.
         * </p>
         * 
         * @param datasourcePackageIngestHistory
         *        Details on when a data source package was added to a behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackageIngestHistoryWithStrings(
                Map<String, ? extends Map<String, TimestampForCollection>> datasourcePackageIngestHistory);

        /**
         * <p>
         * Details on when a data source package was added to a behavior graph.
         * </p>
         * 
         * @param datasourcePackageIngestHistory
         *        Details on when a data source package was added to a behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasourcePackageIngestHistory(
                Map<DatasourcePackage, ? extends Map<DatasourcePackageIngestState, TimestampForCollection>> datasourcePackageIngestHistory);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String graphArn;

        private Map<String, Map<String, TimestampForCollection>> datasourcePackageIngestHistory = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipDatasources model) {
            accountId(model.accountId);
            graphArn(model.graphArn);
            datasourcePackageIngestHistoryWithStrings(model.datasourcePackageIngestHistory);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Map<String, Map<String, TimestampForCollection.Builder>> getDatasourcePackageIngestHistory() {
            Map<String, Map<String, TimestampForCollection.Builder>> result = DatasourcePackageIngestHistoryCopier
                    .copyToBuilder(this.datasourcePackageIngestHistory);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDatasourcePackageIngestHistory(
                Map<String, ? extends Map<String, TimestampForCollection.BuilderImpl>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier
                    .copyFromBuilder(datasourcePackageIngestHistory);
        }

        @Override
        public final Builder datasourcePackageIngestHistoryWithStrings(
                Map<String, ? extends Map<String, TimestampForCollection>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier.copy(datasourcePackageIngestHistory);
            return this;
        }

        @Override
        public final Builder datasourcePackageIngestHistory(
                Map<DatasourcePackage, ? extends Map<DatasourcePackageIngestState, TimestampForCollection>> datasourcePackageIngestHistory) {
            this.datasourcePackageIngestHistory = DatasourcePackageIngestHistoryCopier
                    .copyEnumToString(datasourcePackageIngestHistory);
            return this;
        }

        @Override
        public MembershipDatasources build() {
            return new MembershipDatasources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
