/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveAsyncClient;
import software.amazon.awssdk.services.detective.model.ListMembersRequest;
import software.amazon.awssdk.services.detective.model.ListMembersResponse;

public class ListMembersPublisher
implements SdkPublisher<ListMembersResponse> {
    private final DetectiveAsyncClient client;
    private final ListMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMembersPublisher(DetectiveAsyncClient client, ListMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMembersPublisher(DetectiveAsyncClient client, ListMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMembersResponseFetcher
    implements AsyncPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMembersResponse> nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersPublisher.this.client.listMembers(ListMembersPublisher.this.firstRequest);
            }
            return ListMembersPublisher.this.client.listMembers((ListMembersRequest)((Object)ListMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

