/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the data source packages ingested by your behavior graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasourcePackageIngestDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasourcePackageIngestDetail.Builder, DatasourcePackageIngestDetail> {
    private static final SdkField<String> DATASOURCE_PACKAGE_INGEST_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatasourcePackageIngestState")
            .getter(getter(DatasourcePackageIngestDetail::datasourcePackageIngestStateAsString))
            .setter(setter(Builder::datasourcePackageIngestState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasourcePackageIngestState")
                    .build()).build();

    private static final SdkField<Map<String, TimestampForCollection>> LAST_INGEST_STATE_CHANGE_FIELD = SdkField
            .<Map<String, TimestampForCollection>> builder(MarshallingType.MAP)
            .memberName("LastIngestStateChange")
            .getter(getter(DatasourcePackageIngestDetail::lastIngestStateChangeAsStrings))
            .setter(setter(Builder::lastIngestStateChangeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastIngestStateChange").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TimestampForCollection> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimestampForCollection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATASOURCE_PACKAGE_INGEST_STATE_FIELD, LAST_INGEST_STATE_CHANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasourcePackageIngestState;

    private final Map<String, TimestampForCollection> lastIngestStateChange;

    private DatasourcePackageIngestDetail(BuilderImpl builder) {
        this.datasourcePackageIngestState = builder.datasourcePackageIngestState;
        this.lastIngestStateChange = builder.lastIngestStateChange;
    }

    /**
     * <p>
     * Details on which data source packages are ingested for a member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datasourcePackageIngestState} will return {@link DatasourcePackageIngestState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #datasourcePackageIngestStateAsString}.
     * </p>
     * 
     * @return Details on which data source packages are ingested for a member account.
     * @see DatasourcePackageIngestState
     */
    public final DatasourcePackageIngestState datasourcePackageIngestState() {
        return DatasourcePackageIngestState.fromValue(datasourcePackageIngestState);
    }

    /**
     * <p>
     * Details on which data source packages are ingested for a member account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #datasourcePackageIngestState} will return {@link DatasourcePackageIngestState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #datasourcePackageIngestStateAsString}.
     * </p>
     * 
     * @return Details on which data source packages are ingested for a member account.
     * @see DatasourcePackageIngestState
     */
    public final String datasourcePackageIngestStateAsString() {
        return datasourcePackageIngestState;
    }

    /**
     * <p>
     * The date a data source package was enabled for this account
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastIngestStateChange} method.
     * </p>
     * 
     * @return The date a data source package was enabled for this account
     */
    public final Map<DatasourcePackageIngestState, TimestampForCollection> lastIngestStateChange() {
        return LastIngestStateChangeDatesCopier.copyStringToEnum(lastIngestStateChange);
    }

    /**
     * For responses, this returns true if the service returned a value for the LastIngestStateChange property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLastIngestStateChange() {
        return lastIngestStateChange != null && !(lastIngestStateChange instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The date a data source package was enabled for this account
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastIngestStateChange} method.
     * </p>
     * 
     * @return The date a data source package was enabled for this account
     */
    public final Map<String, TimestampForCollection> lastIngestStateChangeAsStrings() {
        return lastIngestStateChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasourcePackageIngestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLastIngestStateChange() ? lastIngestStateChangeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcePackageIngestDetail)) {
            return false;
        }
        DatasourcePackageIngestDetail other = (DatasourcePackageIngestDetail) obj;
        return Objects.equals(datasourcePackageIngestStateAsString(), other.datasourcePackageIngestStateAsString())
                && hasLastIngestStateChange() == other.hasLastIngestStateChange()
                && Objects.equals(lastIngestStateChangeAsStrings(), other.lastIngestStateChangeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasourcePackageIngestDetail")
                .add("DatasourcePackageIngestState", datasourcePackageIngestStateAsString())
                .add("LastIngestStateChange", hasLastIngestStateChange() ? lastIngestStateChangeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasourcePackageIngestState":
            return Optional.ofNullable(clazz.cast(datasourcePackageIngestStateAsString()));
        case "LastIngestStateChange":
            return Optional.ofNullable(clazz.cast(lastIngestStateChangeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasourcePackageIngestDetail, T> g) {
        return obj -> g.apply((DatasourcePackageIngestDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasourcePackageIngestDetail> {
        /**
         * <p>
         * Details on which data source packages are ingested for a member account.
         * </p>
         * 
         * @param datasourcePackageIngestState
         *        Details on which data source packages are ingested for a member account.
         * @see DatasourcePackageIngestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasourcePackageIngestState
         */
        Builder datasourcePackageIngestState(String datasourcePackageIngestState);

        /**
         * <p>
         * Details on which data source packages are ingested for a member account.
         * </p>
         * 
         * @param datasourcePackageIngestState
         *        Details on which data source packages are ingested for a member account.
         * @see DatasourcePackageIngestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasourcePackageIngestState
         */
        Builder datasourcePackageIngestState(DatasourcePackageIngestState datasourcePackageIngestState);

        /**
         * <p>
         * The date a data source package was enabled for this account
         * </p>
         * 
         * @param lastIngestStateChange
         *        The date a data source package was enabled for this account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIngestStateChangeWithStrings(Map<String, TimestampForCollection> lastIngestStateChange);

        /**
         * <p>
         * The date a data source package was enabled for this account
         * </p>
         * 
         * @param lastIngestStateChange
         *        The date a data source package was enabled for this account
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIngestStateChange(Map<DatasourcePackageIngestState, TimestampForCollection> lastIngestStateChange);
    }

    static final class BuilderImpl implements Builder {
        private String datasourcePackageIngestState;

        private Map<String, TimestampForCollection> lastIngestStateChange = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasourcePackageIngestDetail model) {
            datasourcePackageIngestState(model.datasourcePackageIngestState);
            lastIngestStateChangeWithStrings(model.lastIngestStateChange);
        }

        public final String getDatasourcePackageIngestState() {
            return datasourcePackageIngestState;
        }

        public final void setDatasourcePackageIngestState(String datasourcePackageIngestState) {
            this.datasourcePackageIngestState = datasourcePackageIngestState;
        }

        @Override
        public final Builder datasourcePackageIngestState(String datasourcePackageIngestState) {
            this.datasourcePackageIngestState = datasourcePackageIngestState;
            return this;
        }

        @Override
        public final Builder datasourcePackageIngestState(DatasourcePackageIngestState datasourcePackageIngestState) {
            this.datasourcePackageIngestState(datasourcePackageIngestState == null ? null : datasourcePackageIngestState
                    .toString());
            return this;
        }

        public final Map<String, TimestampForCollection.Builder> getLastIngestStateChange() {
            Map<String, TimestampForCollection.Builder> result = LastIngestStateChangeDatesCopier
                    .copyToBuilder(this.lastIngestStateChange);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLastIngestStateChange(Map<String, TimestampForCollection.BuilderImpl> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copyFromBuilder(lastIngestStateChange);
        }

        @Override
        public final Builder lastIngestStateChangeWithStrings(Map<String, TimestampForCollection> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copy(lastIngestStateChange);
            return this;
        }

        @Override
        public final Builder lastIngestStateChange(Map<DatasourcePackageIngestState, TimestampForCollection> lastIngestStateChange) {
            this.lastIngestStateChange = LastIngestStateChangeDatesCopier.copyEnumToString(lastIngestStateChange);
            return this;
        }

        @Override
        public DatasourcePackageIngestDetail build() {
            return new DatasourcePackageIngestDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
