/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDiscoveryJobRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, StartDiscoveryJobRequest> {
    private static final SdkField<String> STORAGE_SYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageSystemArn").getter(StartDiscoveryJobRequest.getter(StartDiscoveryJobRequest::storageSystemArn)).setter(StartDiscoveryJobRequest.setter(Builder::storageSystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystemArn").build()}).build();
    private static final SdkField<Integer> COLLECTION_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CollectionDurationMinutes").getter(StartDiscoveryJobRequest.getter(StartDiscoveryJobRequest::collectionDurationMinutes)).setter(StartDiscoveryJobRequest.setter(Builder::collectionDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionDurationMinutes").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartDiscoveryJobRequest.getter(StartDiscoveryJobRequest::clientToken)).setter(StartDiscoveryJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartDiscoveryJobRequest.getter(StartDiscoveryJobRequest::tags)).setter(StartDiscoveryJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEM_ARN_FIELD, COLLECTION_DURATION_MINUTES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String storageSystemArn;
    private final Integer collectionDurationMinutes;
    private final String clientToken;
    private final List<TagListEntry> tags;

    private StartDiscoveryJobRequest(BuilderImpl builder) {
        super(builder);
        this.storageSystemArn = builder.storageSystemArn;
        this.collectionDurationMinutes = builder.collectionDurationMinutes;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String storageSystemArn() {
        return this.storageSystemArn;
    }

    public final Integer collectionDurationMinutes() {
        return this.collectionDurationMinutes;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDiscoveryJobRequest)) {
            return false;
        }
        StartDiscoveryJobRequest other = (StartDiscoveryJobRequest)((Object)obj);
        return Objects.equals(this.storageSystemArn(), other.storageSystemArn()) && Objects.equals(this.collectionDurationMinutes(), other.collectionDurationMinutes()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartDiscoveryJobRequest").add("StorageSystemArn", (Object)this.storageSystemArn()).add("CollectionDurationMinutes", (Object)this.collectionDurationMinutes()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageSystemArn": {
                return Optional.ofNullable(clazz.cast(this.storageSystemArn()));
            }
            case "CollectionDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.collectionDurationMinutes()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDiscoveryJobRequest, T> g) {
        return obj -> g.apply((StartDiscoveryJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String storageSystemArn;
        private Integer collectionDurationMinutes;
        private String clientToken;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDiscoveryJobRequest model) {
            super(model);
            this.storageSystemArn(model.storageSystemArn);
            this.collectionDurationMinutes(model.collectionDurationMinutes);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getStorageSystemArn() {
            return this.storageSystemArn;
        }

        public final void setStorageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
        }

        @Override
        public final Builder storageSystemArn(String storageSystemArn) {
            this.storageSystemArn = storageSystemArn;
            return this;
        }

        public final Integer getCollectionDurationMinutes() {
            return this.collectionDurationMinutes;
        }

        public final void setCollectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
        }

        @Override
        public final Builder collectionDurationMinutes(Integer collectionDurationMinutes) {
            this.collectionDurationMinutes = collectionDurationMinutes;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDiscoveryJobRequest build() {
            return new StartDiscoveryJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDiscoveryJobRequest> {
        public Builder storageSystemArn(String var1);

        public Builder collectionDurationMinutes(Integer var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

