/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.EnabledProtocolsCopier;
import software.amazon.awssdk.services.datasync.model.MaxP95Performance;
import software.amazon.awssdk.services.datasync.model.Recommendation;
import software.amazon.awssdk.services.datasync.model.RecommendationStatus;
import software.amazon.awssdk.services.datasync.model.RecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetAppONTAPSVM
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetAppONTAPSVM> {
    private static final SdkField<String> CLUSTER_UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterUuid").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::clusterUuid)).setter(NetAppONTAPSVM.setter(Builder::clusterUuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterUuid").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::resourceId)).setter(NetAppONTAPSVM.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SVM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SvmName").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::svmName)).setter(NetAppONTAPSVM.setter(Builder::svmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmName").build()}).build();
    private static final SdkField<Long> CIFS_SHARE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CifsShareCount").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::cifsShareCount)).setter(NetAppONTAPSVM.setter(Builder::cifsShareCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CifsShareCount").build()}).build();
    private static final SdkField<List<String>> ENABLED_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledProtocols").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::enabledProtocols)).setter(NetAppONTAPSVM.setter(Builder::enabledProtocols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledProtocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCapacityUsed").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::totalCapacityUsed)).setter(NetAppONTAPSVM.setter(Builder::totalCapacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacityUsed").build()}).build();
    private static final SdkField<Long> TOTAL_CAPACITY_PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCapacityProvisioned").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::totalCapacityProvisioned)).setter(NetAppONTAPSVM.setter(Builder::totalCapacityProvisioned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCapacityProvisioned").build()}).build();
    private static final SdkField<Long> TOTAL_LOGICAL_CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalLogicalCapacityUsed").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::totalLogicalCapacityUsed)).setter(NetAppONTAPSVM.setter(Builder::totalLogicalCapacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLogicalCapacityUsed").build()}).build();
    private static final SdkField<MaxP95Performance> MAX_P95_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxP95Performance").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::maxP95Performance)).setter(NetAppONTAPSVM.setter(Builder::maxP95Performance)).constructor(MaxP95Performance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxP95Performance").build()}).build();
    private static final SdkField<List<Recommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommendations").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::recommendations)).setter(NetAppONTAPSVM.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Recommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> NFS_EXPORTED_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NfsExportedVolumes").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::nfsExportedVolumes)).setter(NetAppONTAPSVM.setter(Builder::nfsExportedVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NfsExportedVolumes").build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationStatus").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::recommendationStatusAsString)).setter(NetAppONTAPSVM.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationStatus").build()}).build();
    private static final SdkField<Long> TOTAL_SNAPSHOT_CAPACITY_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalSnapshotCapacityUsed").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::totalSnapshotCapacityUsed)).setter(NetAppONTAPSVM.setter(Builder::totalSnapshotCapacityUsed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSnapshotCapacityUsed").build()}).build();
    private static final SdkField<Long> LUN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LunCount").getter(NetAppONTAPSVM.getter(NetAppONTAPSVM::lunCount)).setter(NetAppONTAPSVM.setter(Builder::lunCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LunCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_UUID_FIELD, RESOURCE_ID_FIELD, SVM_NAME_FIELD, CIFS_SHARE_COUNT_FIELD, ENABLED_PROTOCOLS_FIELD, TOTAL_CAPACITY_USED_FIELD, TOTAL_CAPACITY_PROVISIONED_FIELD, TOTAL_LOGICAL_CAPACITY_USED_FIELD, MAX_P95_PERFORMANCE_FIELD, RECOMMENDATIONS_FIELD, NFS_EXPORTED_VOLUMES_FIELD, RECOMMENDATION_STATUS_FIELD, TOTAL_SNAPSHOT_CAPACITY_USED_FIELD, LUN_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterUuid;
    private final String resourceId;
    private final String svmName;
    private final Long cifsShareCount;
    private final List<String> enabledProtocols;
    private final Long totalCapacityUsed;
    private final Long totalCapacityProvisioned;
    private final Long totalLogicalCapacityUsed;
    private final MaxP95Performance maxP95Performance;
    private final List<Recommendation> recommendations;
    private final Long nfsExportedVolumes;
    private final String recommendationStatus;
    private final Long totalSnapshotCapacityUsed;
    private final Long lunCount;

    private NetAppONTAPSVM(BuilderImpl builder) {
        this.clusterUuid = builder.clusterUuid;
        this.resourceId = builder.resourceId;
        this.svmName = builder.svmName;
        this.cifsShareCount = builder.cifsShareCount;
        this.enabledProtocols = builder.enabledProtocols;
        this.totalCapacityUsed = builder.totalCapacityUsed;
        this.totalCapacityProvisioned = builder.totalCapacityProvisioned;
        this.totalLogicalCapacityUsed = builder.totalLogicalCapacityUsed;
        this.maxP95Performance = builder.maxP95Performance;
        this.recommendations = builder.recommendations;
        this.nfsExportedVolumes = builder.nfsExportedVolumes;
        this.recommendationStatus = builder.recommendationStatus;
        this.totalSnapshotCapacityUsed = builder.totalSnapshotCapacityUsed;
        this.lunCount = builder.lunCount;
    }

    public final String clusterUuid() {
        return this.clusterUuid;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String svmName() {
        return this.svmName;
    }

    public final Long cifsShareCount() {
        return this.cifsShareCount;
    }

    public final boolean hasEnabledProtocols() {
        return this.enabledProtocols != null && !(this.enabledProtocols instanceof SdkAutoConstructList);
    }

    public final List<String> enabledProtocols() {
        return this.enabledProtocols;
    }

    public final Long totalCapacityUsed() {
        return this.totalCapacityUsed;
    }

    public final Long totalCapacityProvisioned() {
        return this.totalCapacityProvisioned;
    }

    public final Long totalLogicalCapacityUsed() {
        return this.totalLogicalCapacityUsed;
    }

    public final MaxP95Performance maxP95Performance() {
        return this.maxP95Performance;
    }

    public final boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public final List<Recommendation> recommendations() {
        return this.recommendations;
    }

    public final Long nfsExportedVolumes() {
        return this.nfsExportedVolumes;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final Long totalSnapshotCapacityUsed() {
        return this.totalSnapshotCapacityUsed;
    }

    public final Long lunCount() {
        return this.lunCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterUuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.svmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cifsShareCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledProtocols() ? this.enabledProtocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCapacityProvisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLogicalCapacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxP95Performance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendations() ? this.recommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsExportedVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSnapshotCapacityUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.lunCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetAppONTAPSVM)) {
            return false;
        }
        NetAppONTAPSVM other = (NetAppONTAPSVM)obj;
        return Objects.equals(this.clusterUuid(), other.clusterUuid()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.svmName(), other.svmName()) && Objects.equals(this.cifsShareCount(), other.cifsShareCount()) && this.hasEnabledProtocols() == other.hasEnabledProtocols() && Objects.equals(this.enabledProtocols(), other.enabledProtocols()) && Objects.equals(this.totalCapacityUsed(), other.totalCapacityUsed()) && Objects.equals(this.totalCapacityProvisioned(), other.totalCapacityProvisioned()) && Objects.equals(this.totalLogicalCapacityUsed(), other.totalLogicalCapacityUsed()) && Objects.equals(this.maxP95Performance(), other.maxP95Performance()) && this.hasRecommendations() == other.hasRecommendations() && Objects.equals(this.recommendations(), other.recommendations()) && Objects.equals(this.nfsExportedVolumes(), other.nfsExportedVolumes()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && Objects.equals(this.totalSnapshotCapacityUsed(), other.totalSnapshotCapacityUsed()) && Objects.equals(this.lunCount(), other.lunCount());
    }

    public final String toString() {
        return ToString.builder((String)"NetAppONTAPSVM").add("ClusterUuid", (Object)this.clusterUuid()).add("ResourceId", (Object)this.resourceId()).add("SvmName", (Object)this.svmName()).add("CifsShareCount", (Object)this.cifsShareCount()).add("EnabledProtocols", this.hasEnabledProtocols() ? this.enabledProtocols() : null).add("TotalCapacityUsed", (Object)this.totalCapacityUsed()).add("TotalCapacityProvisioned", (Object)this.totalCapacityProvisioned()).add("TotalLogicalCapacityUsed", (Object)this.totalLogicalCapacityUsed()).add("MaxP95Performance", (Object)this.maxP95Performance()).add("Recommendations", this.hasRecommendations() ? this.recommendations() : null).add("NfsExportedVolumes", (Object)this.nfsExportedVolumes()).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("TotalSnapshotCapacityUsed", (Object)this.totalSnapshotCapacityUsed()).add("LunCount", (Object)this.lunCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterUuid": {
                return Optional.ofNullable(clazz.cast(this.clusterUuid()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "SvmName": {
                return Optional.ofNullable(clazz.cast(this.svmName()));
            }
            case "CifsShareCount": {
                return Optional.ofNullable(clazz.cast(this.cifsShareCount()));
            }
            case "EnabledProtocols": {
                return Optional.ofNullable(clazz.cast(this.enabledProtocols()));
            }
            case "TotalCapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.totalCapacityUsed()));
            }
            case "TotalCapacityProvisioned": {
                return Optional.ofNullable(clazz.cast(this.totalCapacityProvisioned()));
            }
            case "TotalLogicalCapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.totalLogicalCapacityUsed()));
            }
            case "MaxP95Performance": {
                return Optional.ofNullable(clazz.cast(this.maxP95Performance()));
            }
            case "Recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "NfsExportedVolumes": {
                return Optional.ofNullable(clazz.cast(this.nfsExportedVolumes()));
            }
            case "RecommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "TotalSnapshotCapacityUsed": {
                return Optional.ofNullable(clazz.cast(this.totalSnapshotCapacityUsed()));
            }
            case "LunCount": {
                return Optional.ofNullable(clazz.cast(this.lunCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetAppONTAPSVM, T> g) {
        return obj -> g.apply((NetAppONTAPSVM)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterUuid;
        private String resourceId;
        private String svmName;
        private Long cifsShareCount;
        private List<String> enabledProtocols = DefaultSdkAutoConstructList.getInstance();
        private Long totalCapacityUsed;
        private Long totalCapacityProvisioned;
        private Long totalLogicalCapacityUsed;
        private MaxP95Performance maxP95Performance;
        private List<Recommendation> recommendations = DefaultSdkAutoConstructList.getInstance();
        private Long nfsExportedVolumes;
        private String recommendationStatus;
        private Long totalSnapshotCapacityUsed;
        private Long lunCount;

        private BuilderImpl() {
        }

        private BuilderImpl(NetAppONTAPSVM model) {
            this.clusterUuid(model.clusterUuid);
            this.resourceId(model.resourceId);
            this.svmName(model.svmName);
            this.cifsShareCount(model.cifsShareCount);
            this.enabledProtocols(model.enabledProtocols);
            this.totalCapacityUsed(model.totalCapacityUsed);
            this.totalCapacityProvisioned(model.totalCapacityProvisioned);
            this.totalLogicalCapacityUsed(model.totalLogicalCapacityUsed);
            this.maxP95Performance(model.maxP95Performance);
            this.recommendations(model.recommendations);
            this.nfsExportedVolumes(model.nfsExportedVolumes);
            this.recommendationStatus(model.recommendationStatus);
            this.totalSnapshotCapacityUsed(model.totalSnapshotCapacityUsed);
            this.lunCount(model.lunCount);
        }

        public final String getClusterUuid() {
            return this.clusterUuid;
        }

        public final void setClusterUuid(String clusterUuid) {
            this.clusterUuid = clusterUuid;
        }

        @Override
        public final Builder clusterUuid(String clusterUuid) {
            this.clusterUuid = clusterUuid;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getSvmName() {
            return this.svmName;
        }

        public final void setSvmName(String svmName) {
            this.svmName = svmName;
        }

        @Override
        public final Builder svmName(String svmName) {
            this.svmName = svmName;
            return this;
        }

        public final Long getCifsShareCount() {
            return this.cifsShareCount;
        }

        public final void setCifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
        }

        @Override
        public final Builder cifsShareCount(Long cifsShareCount) {
            this.cifsShareCount = cifsShareCount;
            return this;
        }

        public final Collection<String> getEnabledProtocols() {
            if (this.enabledProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledProtocols;
        }

        public final void setEnabledProtocols(Collection<String> enabledProtocols) {
            this.enabledProtocols = EnabledProtocolsCopier.copy(enabledProtocols);
        }

        @Override
        public final Builder enabledProtocols(Collection<String> enabledProtocols) {
            this.enabledProtocols = EnabledProtocolsCopier.copy(enabledProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledProtocols(String ... enabledProtocols) {
            this.enabledProtocols(Arrays.asList(enabledProtocols));
            return this;
        }

        public final Long getTotalCapacityUsed() {
            return this.totalCapacityUsed;
        }

        public final void setTotalCapacityUsed(Long totalCapacityUsed) {
            this.totalCapacityUsed = totalCapacityUsed;
        }

        @Override
        public final Builder totalCapacityUsed(Long totalCapacityUsed) {
            this.totalCapacityUsed = totalCapacityUsed;
            return this;
        }

        public final Long getTotalCapacityProvisioned() {
            return this.totalCapacityProvisioned;
        }

        public final void setTotalCapacityProvisioned(Long totalCapacityProvisioned) {
            this.totalCapacityProvisioned = totalCapacityProvisioned;
        }

        @Override
        public final Builder totalCapacityProvisioned(Long totalCapacityProvisioned) {
            this.totalCapacityProvisioned = totalCapacityProvisioned;
            return this;
        }

        public final Long getTotalLogicalCapacityUsed() {
            return this.totalLogicalCapacityUsed;
        }

        public final void setTotalLogicalCapacityUsed(Long totalLogicalCapacityUsed) {
            this.totalLogicalCapacityUsed = totalLogicalCapacityUsed;
        }

        @Override
        public final Builder totalLogicalCapacityUsed(Long totalLogicalCapacityUsed) {
            this.totalLogicalCapacityUsed = totalLogicalCapacityUsed;
            return this;
        }

        public final MaxP95Performance.Builder getMaxP95Performance() {
            return this.maxP95Performance != null ? this.maxP95Performance.toBuilder() : null;
        }

        public final void setMaxP95Performance(MaxP95Performance.BuilderImpl maxP95Performance) {
            this.maxP95Performance = maxP95Performance != null ? maxP95Performance.build() : null;
        }

        @Override
        public final Builder maxP95Performance(MaxP95Performance maxP95Performance) {
            this.maxP95Performance = maxP95Performance;
            return this;
        }

        public final List<Recommendation.Builder> getRecommendations() {
            List<Recommendation.Builder> result = RecommendationsCopier.copyToBuilder(this.recommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendations(Collection<Recommendation.BuilderImpl> recommendations) {
            this.recommendations = RecommendationsCopier.copyFromBuilder(recommendations);
        }

        @Override
        public final Builder recommendations(Collection<Recommendation> recommendations) {
            this.recommendations = RecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Recommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<Recommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (Recommendation)((Recommendation.Builder)Recommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getNfsExportedVolumes() {
            return this.nfsExportedVolumes;
        }

        public final void setNfsExportedVolumes(Long nfsExportedVolumes) {
            this.nfsExportedVolumes = nfsExportedVolumes;
        }

        @Override
        public final Builder nfsExportedVolumes(Long nfsExportedVolumes) {
            this.nfsExportedVolumes = nfsExportedVolumes;
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final Long getTotalSnapshotCapacityUsed() {
            return this.totalSnapshotCapacityUsed;
        }

        public final void setTotalSnapshotCapacityUsed(Long totalSnapshotCapacityUsed) {
            this.totalSnapshotCapacityUsed = totalSnapshotCapacityUsed;
        }

        @Override
        public final Builder totalSnapshotCapacityUsed(Long totalSnapshotCapacityUsed) {
            this.totalSnapshotCapacityUsed = totalSnapshotCapacityUsed;
            return this;
        }

        public final Long getLunCount() {
            return this.lunCount;
        }

        public final void setLunCount(Long lunCount) {
            this.lunCount = lunCount;
        }

        @Override
        public final Builder lunCount(Long lunCount) {
            this.lunCount = lunCount;
            return this;
        }

        public NetAppONTAPSVM build() {
            return new NetAppONTAPSVM(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetAppONTAPSVM> {
        public Builder clusterUuid(String var1);

        public Builder resourceId(String var1);

        public Builder svmName(String var1);

        public Builder cifsShareCount(Long var1);

        public Builder enabledProtocols(Collection<String> var1);

        public Builder enabledProtocols(String ... var1);

        public Builder totalCapacityUsed(Long var1);

        public Builder totalCapacityProvisioned(Long var1);

        public Builder totalLogicalCapacityUsed(Long var1);

        public Builder maxP95Performance(MaxP95Performance var1);

        default public Builder maxP95Performance(Consumer<MaxP95Performance.Builder> maxP95Performance) {
            return this.maxP95Performance((MaxP95Performance)((MaxP95Performance.Builder)MaxP95Performance.builder().applyMutation(maxP95Performance)).build());
        }

        public Builder recommendations(Collection<Recommendation> var1);

        public Builder recommendations(Recommendation ... var1);

        public Builder recommendations(Consumer<Recommendation.Builder> ... var1);

        public Builder nfsExportedVolumes(Long var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder totalSnapshotCapacityUsed(Long var1);

        public Builder lunCount(Long var1);
    }
}

