/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobListCopier;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDiscoveryJobsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, ListDiscoveryJobsResponse> {
    private static final SdkField<List<DiscoveryJobListEntry>> DISCOVERY_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiscoveryJobs").getter(ListDiscoveryJobsResponse.getter(ListDiscoveryJobsResponse::discoveryJobs)).setter(ListDiscoveryJobsResponse.setter(Builder::discoveryJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiscoveryJobListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDiscoveryJobsResponse.getter(ListDiscoveryJobsResponse::nextToken)).setter(ListDiscoveryJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DiscoveryJobListEntry> discoveryJobs;
    private final String nextToken;

    private ListDiscoveryJobsResponse(BuilderImpl builder) {
        super(builder);
        this.discoveryJobs = builder.discoveryJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDiscoveryJobs() {
        return this.discoveryJobs != null && !(this.discoveryJobs instanceof SdkAutoConstructList);
    }

    public final List<DiscoveryJobListEntry> discoveryJobs() {
        return this.discoveryJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiscoveryJobs() ? this.discoveryJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveryJobsResponse)) {
            return false;
        }
        ListDiscoveryJobsResponse other = (ListDiscoveryJobsResponse)((Object)obj);
        return this.hasDiscoveryJobs() == other.hasDiscoveryJobs() && Objects.equals(this.discoveryJobs(), other.discoveryJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDiscoveryJobsResponse").add("DiscoveryJobs", this.hasDiscoveryJobs() ? this.discoveryJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscoveryJobs": {
                return Optional.ofNullable(clazz.cast(this.discoveryJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDiscoveryJobsResponse, T> g) {
        return obj -> g.apply((ListDiscoveryJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private List<DiscoveryJobListEntry> discoveryJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDiscoveryJobsResponse model) {
            super(model);
            this.discoveryJobs(model.discoveryJobs);
            this.nextToken(model.nextToken);
        }

        public final List<DiscoveryJobListEntry.Builder> getDiscoveryJobs() {
            List<DiscoveryJobListEntry.Builder> result = DiscoveryJobListCopier.copyToBuilder(this.discoveryJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDiscoveryJobs(Collection<DiscoveryJobListEntry.BuilderImpl> discoveryJobs) {
            this.discoveryJobs = DiscoveryJobListCopier.copyFromBuilder(discoveryJobs);
        }

        @Override
        public final Builder discoveryJobs(Collection<DiscoveryJobListEntry> discoveryJobs) {
            this.discoveryJobs = DiscoveryJobListCopier.copy(discoveryJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder discoveryJobs(DiscoveryJobListEntry ... discoveryJobs) {
            this.discoveryJobs(Arrays.asList(discoveryJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder discoveryJobs(Consumer<DiscoveryJobListEntry.Builder> ... discoveryJobs) {
            this.discoveryJobs(Stream.of(discoveryJobs).map(c -> (DiscoveryJobListEntry)((DiscoveryJobListEntry.Builder)DiscoveryJobListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDiscoveryJobsResponse build() {
            return new ListDiscoveryJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDiscoveryJobsResponse> {
        public Builder discoveryJobs(Collection<DiscoveryJobListEntry> var1);

        public Builder discoveryJobs(DiscoveryJobListEntry ... var1);

        public Builder discoveryJobs(Consumer<DiscoveryJobListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

