/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Amazon S3 bucket where DataSync uploads your <a
 * href="https://docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html">task report</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDestinationS3 implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportDestinationS3.Builder, ReportDestinationS3> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Subdirectory").getter(getter(ReportDestinationS3::subdirectory)).setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketArn").getter(getter(ReportDestinationS3::s3BucketArn)).setter(setter(Builder::s3BucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketArn").build()).build();

    private static final SdkField<String> BUCKET_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketAccessRoleArn").getter(getter(ReportDestinationS3::bucketAccessRoleArn))
            .setter(setter(Builder::bucketAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD,
            S3_BUCKET_ARN_FIELD, BUCKET_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subdirectory;

    private final String s3BucketArn;

    private final String bucketAccessRoleArn;

    private ReportDestinationS3(BuilderImpl builder) {
        this.subdirectory = builder.subdirectory;
        this.s3BucketArn = builder.s3BucketArn;
        this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
    }

    /**
     * <p>
     * Specifies a bucket prefix for your report.
     * </p>
     * 
     * @return Specifies a bucket prefix for your report.
     */
    public final String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * Specifies the ARN of the S3 bucket where DataSync uploads your report.
     * </p>
     * 
     * @return Specifies the ARN of the S3 bucket where DataSync uploads your report.
     */
    public final String s3BucketArn() {
        return s3BucketArn;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to your
     * S3 bucket. For more information, see <a href=
     * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html"
     * >Allowing DataSync to upload a task report to an Amazon S3 bucket</a>.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report
     *         to your S3 bucket. For more information, see <a href=
     *         "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html"
     *         >Allowing DataSync to upload a task report to an Amazon S3 bucket</a>.
     */
    public final String bucketAccessRoleArn() {
        return bucketAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(bucketAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestinationS3)) {
            return false;
        }
        ReportDestinationS3 other = (ReportDestinationS3) obj;
        return Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(s3BucketArn(), other.s3BucketArn())
                && Objects.equals(bucketAccessRoleArn(), other.bucketAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDestinationS3").add("Subdirectory", subdirectory()).add("S3BucketArn", s3BucketArn())
                .add("BucketAccessRoleArn", bucketAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "S3BucketArn":
            return Optional.ofNullable(clazz.cast(s3BucketArn()));
        case "BucketAccessRoleArn":
            return Optional.ofNullable(clazz.cast(bucketAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDestinationS3, T> g) {
        return obj -> g.apply((ReportDestinationS3) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDestinationS3> {
        /**
         * <p>
         * Specifies a bucket prefix for your report.
         * </p>
         * 
         * @param subdirectory
         *        Specifies a bucket prefix for your report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * Specifies the ARN of the S3 bucket where DataSync uploads your report.
         * </p>
         * 
         * @param s3BucketArn
         *        Specifies the ARN of the S3 bucket where DataSync uploads your report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketArn(String s3BucketArn);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task report to
         * your S3 bucket. For more information, see <a href=
         * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html"
         * >Allowing DataSync to upload a task report to an Amazon S3 bucket</a>.
         * </p>
         * 
         * @param bucketAccessRoleArn
         *        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync to upload a task
         *        report to your S3 bucket. For more information, see <a href=
         *        "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/datasync/latest/userguide/creating-task-reports.html"
         *        >Allowing DataSync to upload a task report to an Amazon S3 bucket</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketAccessRoleArn(String bucketAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String subdirectory;

        private String s3BucketArn;

        private String bucketAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDestinationS3 model) {
            subdirectory(model.subdirectory);
            s3BucketArn(model.s3BucketArn);
            bucketAccessRoleArn(model.bucketAccessRoleArn);
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getS3BucketArn() {
            return s3BucketArn;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final String getBucketAccessRoleArn() {
            return bucketAccessRoleArn;
        }

        public final void setBucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
        }

        @Override
        public final Builder bucketAccessRoleArn(String bucketAccessRoleArn) {
            this.bucketAccessRoleArn = bucketAccessRoleArn;
            return this;
        }

        @Override
        public ReportDestinationS3 build() {
            return new ReportDestinationS3(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
