/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source details for an Amazon S3 data access asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DataAccessAssetSourceEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DataAccessAssetSourceEntry.Builder, S3DataAccessAssetSourceEntry> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(S3DataAccessAssetSourceEntry::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<List<String>> KEY_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KeyPrefixes")
            .getter(getter(S3DataAccessAssetSourceEntry::keyPrefixes))
            .setter(setter(Builder::keyPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(S3DataAccessAssetSourceEntry::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KmsKeyToGrant>> KMS_KEYS_TO_GRANT_FIELD = SdkField
            .<List<KmsKeyToGrant>> builder(MarshallingType.LIST)
            .memberName("KmsKeysToGrant")
            .getter(getter(S3DataAccessAssetSourceEntry::kmsKeysToGrant))
            .setter(setter(Builder::kmsKeysToGrant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeysToGrant").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KmsKeyToGrant> builder(MarshallingType.SDK_POJO)
                                            .constructor(KmsKeyToGrant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            KEY_PREFIXES_FIELD, KEYS_FIELD, KMS_KEYS_TO_GRANT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final List<String> keyPrefixes;

    private final List<String> keys;

    private final List<KmsKeyToGrant> kmsKeysToGrant;

    private S3DataAccessAssetSourceEntry(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPrefixes = builder.keyPrefixes;
        this.keys = builder.keys;
        this.kmsKeysToGrant = builder.kmsKeysToGrant;
    }

    /**
     * <p>
     * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
     * </p>
     * 
     * @return The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyPrefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyPrefixes() {
        return keyPrefixes != null && !(keyPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyPrefixes} method.
     * </p>
     * 
     * @return Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
     */
    public final List<String> keyPrefixes() {
        return keyPrefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The keys used to create the Amazon S3 data access.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The keys used to create the Amazon S3 data access.
     */
    public final List<String> keys() {
        return keys;
    }

    /**
     * For responses, this returns true if the service returned a value for the KmsKeysToGrant property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsKeysToGrant() {
        return kmsKeysToGrant != null && !(kmsKeysToGrant instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being
     * shared in this S3 Data Access asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsKeysToGrant} method.
     * </p>
     * 
     * @return List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects
     *         being shared in this S3 Data Access asset.
     */
    public final List<KmsKeyToGrant> kmsKeysToGrant() {
        return kmsKeysToGrant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyPrefixes() ? keyPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsKeysToGrant() ? kmsKeysToGrant() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DataAccessAssetSourceEntry)) {
            return false;
        }
        S3DataAccessAssetSourceEntry other = (S3DataAccessAssetSourceEntry) obj;
        return Objects.equals(bucket(), other.bucket()) && hasKeyPrefixes() == other.hasKeyPrefixes()
                && Objects.equals(keyPrefixes(), other.keyPrefixes()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && hasKmsKeysToGrant() == other.hasKmsKeysToGrant()
                && Objects.equals(kmsKeysToGrant(), other.kmsKeysToGrant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DataAccessAssetSourceEntry").add("Bucket", bucket())
                .add("KeyPrefixes", hasKeyPrefixes() ? keyPrefixes() : null).add("Keys", hasKeys() ? keys() : null)
                .add("KmsKeysToGrant", hasKmsKeysToGrant() ? kmsKeysToGrant() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "KeyPrefixes":
            return Optional.ofNullable(clazz.cast(keyPrefixes()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "KmsKeysToGrant":
            return Optional.ofNullable(clazz.cast(kmsKeysToGrant()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DataAccessAssetSourceEntry, T> g) {
        return obj -> g.apply((S3DataAccessAssetSourceEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DataAccessAssetSourceEntry> {
        /**
         * <p>
         * The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket used for hosting shared data in the Amazon S3 data access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
         * </p>
         * 
         * @param keyPrefixes
         *        Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixes(Collection<String> keyPrefixes);

        /**
         * <p>
         * Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
         * </p>
         * 
         * @param keyPrefixes
         *        Organizes Amazon S3 asset key prefixes stored in an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixes(String... keyPrefixes);

        /**
         * <p>
         * The keys used to create the Amazon S3 data access.
         * </p>
         * 
         * @param keys
         *        The keys used to create the Amazon S3 data access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * The keys used to create the Amazon S3 data access.
         * </p>
         * 
         * @param keys
         *        The keys used to create the Amazon S3 data access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);

        /**
         * <p>
         * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being
         * shared in this S3 Data Access asset.
         * </p>
         * 
         * @param kmsKeysToGrant
         *        List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects
         *        being shared in this S3 Data Access asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeysToGrant(Collection<KmsKeyToGrant> kmsKeysToGrant);

        /**
         * <p>
         * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being
         * shared in this S3 Data Access asset.
         * </p>
         * 
         * @param kmsKeysToGrant
         *        List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects
         *        being shared in this S3 Data Access asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeysToGrant(KmsKeyToGrant... kmsKeysToGrant);

        /**
         * <p>
         * List of AWS KMS CMKs (Key Management System Customer Managed Keys) and ARNs used to encrypt S3 objects being
         * shared in this S3 Data Access asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant.Builder#build()} is called
         * immediately and its result is passed to {@link #kmsKeysToGrant(List<KmsKeyToGrant>)}.
         * 
         * @param kmsKeysToGrant
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dataexchange.model.KmsKeyToGrant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsKeysToGrant(java.util.Collection<KmsKeyToGrant>)
         */
        Builder kmsKeysToGrant(Consumer<KmsKeyToGrant.Builder>... kmsKeysToGrant);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private List<String> keyPrefixes = DefaultSdkAutoConstructList.getInstance();

        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private List<KmsKeyToGrant> kmsKeysToGrant = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DataAccessAssetSourceEntry model) {
            bucket(model.bucket);
            keyPrefixes(model.keyPrefixes);
            keys(model.keys);
            kmsKeysToGrant(model.kmsKeysToGrant);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final Collection<String> getKeyPrefixes() {
            if (keyPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return keyPrefixes;
        }

        public final void setKeyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
        }

        @Override
        public final Builder keyPrefixes(Collection<String> keyPrefixes) {
            this.keyPrefixes = ListOf__stringCopier.copy(keyPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPrefixes(String... keyPrefixes) {
            keyPrefixes(Arrays.asList(keyPrefixes));
            return this;
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = ListOf__stringCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        public final List<KmsKeyToGrant.Builder> getKmsKeysToGrant() {
            List<KmsKeyToGrant.Builder> result = ListOfKmsKeysToGrantCopier.copyToBuilder(this.kmsKeysToGrant);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKmsKeysToGrant(Collection<KmsKeyToGrant.BuilderImpl> kmsKeysToGrant) {
            this.kmsKeysToGrant = ListOfKmsKeysToGrantCopier.copyFromBuilder(kmsKeysToGrant);
        }

        @Override
        public final Builder kmsKeysToGrant(Collection<KmsKeyToGrant> kmsKeysToGrant) {
            this.kmsKeysToGrant = ListOfKmsKeysToGrantCopier.copy(kmsKeysToGrant);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kmsKeysToGrant(KmsKeyToGrant... kmsKeysToGrant) {
            kmsKeysToGrant(Arrays.asList(kmsKeysToGrant));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kmsKeysToGrant(Consumer<KmsKeyToGrant.Builder>... kmsKeysToGrant) {
            kmsKeysToGrant(Stream.of(kmsKeysToGrant).map(c -> KmsKeyToGrant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3DataAccessAssetSourceEntry build() {
            return new S3DataAccessAssetSourceEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
