/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * What occurs to start an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<RevisionPublished> REVISION_PUBLISHED_FIELD = SdkField
            .<RevisionPublished> builder(MarshallingType.SDK_POJO).memberName("RevisionPublished")
            .getter(getter(Event::revisionPublished)).setter(setter(Builder::revisionPublished))
            .constructor(RevisionPublished::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionPublished").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_PUBLISHED_FIELD));

    private static final long serialVersionUID = 1L;

    private final RevisionPublished revisionPublished;

    private Event(BuilderImpl builder) {
        this.revisionPublished = builder.revisionPublished;
    }

    /**
     * <p>
     * What occurs to start the revision publish action.
     * </p>
     * 
     * @return What occurs to start the revision publish action.
     */
    public final RevisionPublished revisionPublished() {
        return revisionPublished;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionPublished());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(revisionPublished(), other.revisionPublished());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Event").add("RevisionPublished", revisionPublished()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RevisionPublished":
            return Optional.ofNullable(clazz.cast(revisionPublished()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * What occurs to start the revision publish action.
         * </p>
         * 
         * @param revisionPublished
         *        What occurs to start the revision publish action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionPublished(RevisionPublished revisionPublished);

        /**
         * <p>
         * What occurs to start the revision publish action.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionPublished.Builder} avoiding the
         * need to create one manually via {@link RevisionPublished#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevisionPublished.Builder#build()} is called immediately and its
         * result is passed to {@link #revisionPublished(RevisionPublished)}.
         * 
         * @param revisionPublished
         *        a consumer that will call methods on {@link RevisionPublished.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revisionPublished(RevisionPublished)
         */
        default Builder revisionPublished(Consumer<RevisionPublished.Builder> revisionPublished) {
            return revisionPublished(RevisionPublished.builder().applyMutation(revisionPublished).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RevisionPublished revisionPublished;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            revisionPublished(model.revisionPublished);
        }

        public final RevisionPublished.Builder getRevisionPublished() {
            return revisionPublished != null ? revisionPublished.toBuilder() : null;
        }

        public final void setRevisionPublished(RevisionPublished.BuilderImpl revisionPublished) {
            this.revisionPublished = revisionPublished != null ? revisionPublished.build() : null;
        }

        @Override
        public final Builder revisionPublished(RevisionPublished revisionPublished) {
            this.revisionPublished = revisionPublished;
            return this;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
