/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Extra details specific to a data update type notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataUpdateRequestDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DataUpdateRequestDetails.Builder, DataUpdateRequestDetails> {
    private static final SdkField<Instant> DATA_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataUpdatedAt")
            .getter(getter(DataUpdateRequestDetails::dataUpdatedAt))
            .setter(setter(Builder::dataUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant dataUpdatedAt;

    private DataUpdateRequestDetails(BuilderImpl builder) {
        this.dataUpdatedAt = builder.dataUpdatedAt;
    }

    /**
     * <p>
     * A datetime in the past when the data was updated. This typically means that the underlying resource supporting
     * the data set was updated.
     * </p>
     * 
     * @return A datetime in the past when the data was updated. This typically means that the underlying resource
     *         supporting the data set was updated.
     */
    public final Instant dataUpdatedAt() {
        return dataUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataUpdateRequestDetails)) {
            return false;
        }
        DataUpdateRequestDetails other = (DataUpdateRequestDetails) obj;
        return Objects.equals(dataUpdatedAt(), other.dataUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataUpdateRequestDetails").add("DataUpdatedAt", dataUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataUpdatedAt":
            return Optional.ofNullable(clazz.cast(dataUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataUpdateRequestDetails, T> g) {
        return obj -> g.apply((DataUpdateRequestDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataUpdateRequestDetails> {
        /**
         * <p>
         * A datetime in the past when the data was updated. This typically means that the underlying resource
         * supporting the data set was updated.
         * </p>
         * 
         * @param dataUpdatedAt
         *        A datetime in the past when the data was updated. This typically means that the underlying resource
         *        supporting the data set was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataUpdatedAt(Instant dataUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant dataUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataUpdateRequestDetails model) {
            dataUpdatedAt(model.dataUpdatedAt);
        }

        public final Instant getDataUpdatedAt() {
            return dataUpdatedAt;
        }

        public final void setDataUpdatedAt(Instant dataUpdatedAt) {
            this.dataUpdatedAt = dataUpdatedAt;
        }

        @Override
        public final Builder dataUpdatedAt(Instant dataUpdatedAt) {
            this.dataUpdatedAt = dataUpdatedAt;
            return this;
        }

        @Override
        public DataUpdateRequestDetails build() {
            return new DataUpdateRequestDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
