/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databrew.model.DatabaseOutputMode;
import software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseOutput> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlueConnectionName").getter(DatabaseOutput.getter(DatabaseOutput::glueConnectionName)).setter(DatabaseOutput.setter(Builder::glueConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueConnectionName").build()}).build();
    private static final SdkField<DatabaseTableOutputOptions> DATABASE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseOptions").getter(DatabaseOutput.getter(DatabaseOutput::databaseOptions)).setter(DatabaseOutput.setter(Builder::databaseOptions)).constructor(DatabaseTableOutputOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOptions").build()}).build();
    private static final SdkField<String> DATABASE_OUTPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseOutputMode").getter(DatabaseOutput.getter(DatabaseOutput::databaseOutputModeAsString)).setter(DatabaseOutput.setter(Builder::databaseOutputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseOutputMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD, DATABASE_OPTIONS_FIELD, DATABASE_OUTPUT_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String glueConnectionName;
    private final DatabaseTableOutputOptions databaseOptions;
    private final String databaseOutputMode;

    private DatabaseOutput(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.databaseOptions = builder.databaseOptions;
        this.databaseOutputMode = builder.databaseOutputMode;
    }

    public final String glueConnectionName() {
        return this.glueConnectionName;
    }

    public final DatabaseTableOutputOptions databaseOptions() {
        return this.databaseOptions;
    }

    public final DatabaseOutputMode databaseOutputMode() {
        return DatabaseOutputMode.fromValue(this.databaseOutputMode);
    }

    public final String databaseOutputModeAsString() {
        return this.databaseOutputMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseOutputModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseOutput)) {
            return false;
        }
        DatabaseOutput other = (DatabaseOutput)obj;
        return Objects.equals(this.glueConnectionName(), other.glueConnectionName()) && Objects.equals(this.databaseOptions(), other.databaseOptions()) && Objects.equals(this.databaseOutputModeAsString(), other.databaseOutputModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseOutput").add("GlueConnectionName", (Object)this.glueConnectionName()).add("DatabaseOptions", (Object)this.databaseOptions()).add("DatabaseOutputMode", (Object)this.databaseOutputModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlueConnectionName": {
                return Optional.ofNullable(clazz.cast(this.glueConnectionName()));
            }
            case "DatabaseOptions": {
                return Optional.ofNullable(clazz.cast(this.databaseOptions()));
            }
            case "DatabaseOutputMode": {
                return Optional.ofNullable(clazz.cast(this.databaseOutputModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseOutput, T> g) {
        return obj -> g.apply((DatabaseOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String glueConnectionName;
        private DatabaseTableOutputOptions databaseOptions;
        private String databaseOutputMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseOutput model) {
            this.glueConnectionName(model.glueConnectionName);
            this.databaseOptions(model.databaseOptions);
            this.databaseOutputMode(model.databaseOutputMode);
        }

        public final String getGlueConnectionName() {
            return this.glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            this.glueConnectionName = glueConnectionName;
            return this;
        }

        public final DatabaseTableOutputOptions.Builder getDatabaseOptions() {
            return this.databaseOptions != null ? this.databaseOptions.toBuilder() : null;
        }

        public final void setDatabaseOptions(DatabaseTableOutputOptions.BuilderImpl databaseOptions) {
            this.databaseOptions = databaseOptions != null ? databaseOptions.build() : null;
        }

        @Override
        public final Builder databaseOptions(DatabaseTableOutputOptions databaseOptions) {
            this.databaseOptions = databaseOptions;
            return this;
        }

        public final String getDatabaseOutputMode() {
            return this.databaseOutputMode;
        }

        public final void setDatabaseOutputMode(String databaseOutputMode) {
            this.databaseOutputMode = databaseOutputMode;
        }

        @Override
        public final Builder databaseOutputMode(String databaseOutputMode) {
            this.databaseOutputMode = databaseOutputMode;
            return this;
        }

        @Override
        public final Builder databaseOutputMode(DatabaseOutputMode databaseOutputMode) {
            this.databaseOutputMode(databaseOutputMode == null ? null : databaseOutputMode.toString());
            return this;
        }

        public DatabaseOutput build() {
            return new DatabaseOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseOutput> {
        public Builder glueConnectionName(String var1);

        public Builder databaseOptions(DatabaseTableOutputOptions var1);

        default public Builder databaseOptions(Consumer<DatabaseTableOutputOptions.Builder> databaseOptions) {
            return this.databaseOptions((DatabaseTableOutputOptions)((DatabaseTableOutputOptions.Builder)DatabaseTableOutputOptions.builder().applyMutation(databaseOptions)).build());
        }

        public Builder databaseOutputMode(String var1);

        public Builder databaseOutputMode(DatabaseOutputMode var1);
    }
}

