/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.FieldSourceProfileIds;
import software.amazon.awssdk.services.customerprofiles.model.ProfileIdToBeMergedListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeProfilesRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, MergeProfilesRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(MergeProfilesRequest.getter(MergeProfilesRequest::domainName)).setter(MergeProfilesRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> MAIN_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MainProfileId").getter(MergeProfilesRequest.getter(MergeProfilesRequest::mainProfileId)).setter(MergeProfilesRequest.setter(Builder::mainProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MainProfileId").build()}).build();
    private static final SdkField<List<String>> PROFILE_IDS_TO_BE_MERGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileIdsToBeMerged").getter(MergeProfilesRequest.getter(MergeProfilesRequest::profileIdsToBeMerged)).setter(MergeProfilesRequest.setter(Builder::profileIdsToBeMerged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIdsToBeMerged").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FieldSourceProfileIds> FIELD_SOURCE_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldSourceProfileIds").getter(MergeProfilesRequest.getter(MergeProfilesRequest::fieldSourceProfileIds)).setter(MergeProfilesRequest.setter(Builder::fieldSourceProfileIds)).constructor(FieldSourceProfileIds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSourceProfileIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, MAIN_PROFILE_ID_FIELD, PROFILE_IDS_TO_BE_MERGED_FIELD, FIELD_SOURCE_PROFILE_IDS_FIELD));
    private final String domainName;
    private final String mainProfileId;
    private final List<String> profileIdsToBeMerged;
    private final FieldSourceProfileIds fieldSourceProfileIds;

    private MergeProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.mainProfileId = builder.mainProfileId;
        this.profileIdsToBeMerged = builder.profileIdsToBeMerged;
        this.fieldSourceProfileIds = builder.fieldSourceProfileIds;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String mainProfileId() {
        return this.mainProfileId;
    }

    public final boolean hasProfileIdsToBeMerged() {
        return this.profileIdsToBeMerged != null && !(this.profileIdsToBeMerged instanceof SdkAutoConstructList);
    }

    public final List<String> profileIdsToBeMerged() {
        return this.profileIdsToBeMerged;
    }

    public final FieldSourceProfileIds fieldSourceProfileIds() {
        return this.fieldSourceProfileIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mainProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileIdsToBeMerged() ? this.profileIdsToBeMerged() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldSourceProfileIds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeProfilesRequest)) {
            return false;
        }
        MergeProfilesRequest other = (MergeProfilesRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.mainProfileId(), other.mainProfileId()) && this.hasProfileIdsToBeMerged() == other.hasProfileIdsToBeMerged() && Objects.equals(this.profileIdsToBeMerged(), other.profileIdsToBeMerged()) && Objects.equals(this.fieldSourceProfileIds(), other.fieldSourceProfileIds());
    }

    public final String toString() {
        return ToString.builder((String)"MergeProfilesRequest").add("DomainName", (Object)this.domainName()).add("MainProfileId", (Object)this.mainProfileId()).add("ProfileIdsToBeMerged", this.hasProfileIdsToBeMerged() ? this.profileIdsToBeMerged() : null).add("FieldSourceProfileIds", (Object)this.fieldSourceProfileIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "MainProfileId": {
                return Optional.ofNullable(clazz.cast(this.mainProfileId()));
            }
            case "ProfileIdsToBeMerged": {
                return Optional.ofNullable(clazz.cast(this.profileIdsToBeMerged()));
            }
            case "FieldSourceProfileIds": {
                return Optional.ofNullable(clazz.cast(this.fieldSourceProfileIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeProfilesRequest, T> g) {
        return obj -> g.apply((MergeProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String mainProfileId;
        private List<String> profileIdsToBeMerged = DefaultSdkAutoConstructList.getInstance();
        private FieldSourceProfileIds fieldSourceProfileIds;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeProfilesRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.mainProfileId(model.mainProfileId);
            this.profileIdsToBeMerged(model.profileIdsToBeMerged);
            this.fieldSourceProfileIds(model.fieldSourceProfileIds);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getMainProfileId() {
            return this.mainProfileId;
        }

        public final void setMainProfileId(String mainProfileId) {
            this.mainProfileId = mainProfileId;
        }

        @Override
        public final Builder mainProfileId(String mainProfileId) {
            this.mainProfileId = mainProfileId;
            return this;
        }

        public final Collection<String> getProfileIdsToBeMerged() {
            if (this.profileIdsToBeMerged instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileIdsToBeMerged;
        }

        public final void setProfileIdsToBeMerged(Collection<String> profileIdsToBeMerged) {
            this.profileIdsToBeMerged = ProfileIdToBeMergedListCopier.copy(profileIdsToBeMerged);
        }

        @Override
        public final Builder profileIdsToBeMerged(Collection<String> profileIdsToBeMerged) {
            this.profileIdsToBeMerged = ProfileIdToBeMergedListCopier.copy(profileIdsToBeMerged);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIdsToBeMerged(String ... profileIdsToBeMerged) {
            this.profileIdsToBeMerged(Arrays.asList(profileIdsToBeMerged));
            return this;
        }

        public final FieldSourceProfileIds.Builder getFieldSourceProfileIds() {
            return this.fieldSourceProfileIds != null ? this.fieldSourceProfileIds.toBuilder() : null;
        }

        public final void setFieldSourceProfileIds(FieldSourceProfileIds.BuilderImpl fieldSourceProfileIds) {
            this.fieldSourceProfileIds = fieldSourceProfileIds != null ? fieldSourceProfileIds.build() : null;
        }

        @Override
        public final Builder fieldSourceProfileIds(FieldSourceProfileIds fieldSourceProfileIds) {
            this.fieldSourceProfileIds = fieldSourceProfileIds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MergeProfilesRequest build() {
            return new MergeProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MergeProfilesRequest> {
        public Builder domainName(String var1);

        public Builder mainProfileId(String var1);

        public Builder profileIdsToBeMerged(Collection<String> var1);

        public Builder profileIdsToBeMerged(String ... var1);

        public Builder fieldSourceProfileIds(FieldSourceProfileIds var1);

        default public Builder fieldSourceProfileIds(Consumer<FieldSourceProfileIds.Builder> fieldSourceProfileIds) {
            return this.fieldSourceProfileIds((FieldSourceProfileIds)((FieldSourceProfileIds.Builder)FieldSourceProfileIds.builder().applyMutation(fieldSourceProfileIds)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

