/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceConnectorType {
    SALESFORCE("Salesforce"),
    MARKETO("Marketo"),
    ZENDESK("Zendesk"),
    SERVICENOW("Servicenow"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceConnectorType> VALUE_MAP;
    private final String value;

    private SourceConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceConnectorType> knownValues() {
        EnumSet<SourceConnectorType> knownValues = EnumSet.allOf(SourceConnectorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceConnectorType.class, SourceConnectorType::toString);
    }
}

