/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.CostExplorerClientBuilder;
import software.amazon.awssdk.services.costexplorer.CostExplorerServiceClientConfiguration;
import software.amazon.awssdk.services.costexplorer.DefaultCostExplorerBaseClientBuilder;
import software.amazon.awssdk.services.costexplorer.DefaultCostExplorerClient;
import software.amazon.awssdk.services.costexplorer.endpoints.CostExplorerEndpointProvider;

@SdkInternalApi
final class DefaultCostExplorerClientBuilder
extends DefaultCostExplorerBaseClientBuilder<CostExplorerClientBuilder, CostExplorerClient>
implements CostExplorerClientBuilder {
    DefaultCostExplorerClientBuilder() {
    }

    @Override
    public DefaultCostExplorerClientBuilder endpointProvider(CostExplorerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CostExplorerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCostExplorerClientBuilder.validateClientOptions(clientConfiguration);
        CostExplorerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCostExplorerClient client = new DefaultCostExplorerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CostExplorerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CostExplorerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

