/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse;
import software.amazon.awssdk.services.connect.model.TagSet;

public class SearchResourceTagsPublisher
implements SdkPublisher<SearchResourceTagsResponse> {
    private final ConnectAsyncClient client;
    private final SearchResourceTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchResourceTagsPublisher(ConnectAsyncClient client, SearchResourceTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchResourceTagsPublisher(ConnectAsyncClient client, SearchResourceTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchResourceTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchResourceTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TagSet> tags() {
        Function<SearchResourceTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchResourceTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchResourceTagsResponseFetcher
    implements AsyncPageFetcher<SearchResourceTagsResponse> {
        private SearchResourceTagsResponseFetcher() {
        }

        public boolean hasNextPage(SearchResourceTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchResourceTagsResponse> nextPage(SearchResourceTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchResourceTagsPublisher.this.client.searchResourceTags(SearchResourceTagsPublisher.this.firstRequest);
            }
            return SearchResourceTagsPublisher.this.client.searchResourceTags((SearchResourceTagsRequest)((Object)SearchResourceTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

