/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionAutomation;
import software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOption;
import software.amazon.awssdk.services.connect.model.EvaluationFormNumericQuestionOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormNumericQuestionProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormNumericQuestionProperties> {
    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinValue").getter(EvaluationFormNumericQuestionProperties.getter(EvaluationFormNumericQuestionProperties::minValue)).setter(EvaluationFormNumericQuestionProperties.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxValue").getter(EvaluationFormNumericQuestionProperties.getter(EvaluationFormNumericQuestionProperties::maxValue)).setter(EvaluationFormNumericQuestionProperties.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final SdkField<List<EvaluationFormNumericQuestionOption>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(EvaluationFormNumericQuestionProperties.getter(EvaluationFormNumericQuestionProperties::options)).setter(EvaluationFormNumericQuestionProperties.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormNumericQuestionOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormNumericQuestionAutomation> AUTOMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Automation").getter(EvaluationFormNumericQuestionProperties.getter(EvaluationFormNumericQuestionProperties::automation)).setter(EvaluationFormNumericQuestionProperties.setter(Builder::automation)).constructor(EvaluationFormNumericQuestionAutomation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_VALUE_FIELD, MAX_VALUE_FIELD, OPTIONS_FIELD, AUTOMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minValue;
    private final Integer maxValue;
    private final List<EvaluationFormNumericQuestionOption> options;
    private final EvaluationFormNumericQuestionAutomation automation;

    private EvaluationFormNumericQuestionProperties(BuilderImpl builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.options = builder.options;
        this.automation = builder.automation;
    }

    public final Integer minValue() {
        return this.minValue;
    }

    public final Integer maxValue() {
        return this.maxValue;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormNumericQuestionOption> options() {
        return this.options;
    }

    public final EvaluationFormNumericQuestionAutomation automation() {
        return this.automation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.automation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormNumericQuestionProperties)) {
            return false;
        }
        EvaluationFormNumericQuestionProperties other = (EvaluationFormNumericQuestionProperties)obj;
        return Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && Objects.equals(this.automation(), other.automation());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormNumericQuestionProperties").add("MinValue", (Object)this.minValue()).add("MaxValue", (Object)this.maxValue()).add("Options", this.hasOptions() ? this.options() : null).add("Automation", (Object)this.automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Automation": {
                return Optional.ofNullable(clazz.cast(this.automation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormNumericQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormNumericQuestionProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minValue;
        private Integer maxValue;
        private List<EvaluationFormNumericQuestionOption> options = DefaultSdkAutoConstructList.getInstance();
        private EvaluationFormNumericQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormNumericQuestionProperties model) {
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
            this.options(model.options);
            this.automation(model.automation);
        }

        public final Integer getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Integer getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final List<EvaluationFormNumericQuestionOption.Builder> getOptions() {
            List<EvaluationFormNumericQuestionOption.Builder> result = EvaluationFormNumericQuestionOptionListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormNumericQuestionOption.BuilderImpl> options) {
            this.options = EvaluationFormNumericQuestionOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormNumericQuestionOption> options) {
            this.options = EvaluationFormNumericQuestionOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormNumericQuestionOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormNumericQuestionOption.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (EvaluationFormNumericQuestionOption)((EvaluationFormNumericQuestionOption.Builder)EvaluationFormNumericQuestionOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormNumericQuestionAutomation.Builder getAutomation() {
            return this.automation != null ? this.automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormNumericQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormNumericQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        public EvaluationFormNumericQuestionProperties build() {
            return new EvaluationFormNumericQuestionProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormNumericQuestionProperties> {
        public Builder minValue(Integer var1);

        public Builder maxValue(Integer var1);

        public Builder options(Collection<EvaluationFormNumericQuestionOption> var1);

        public Builder options(EvaluationFormNumericQuestionOption ... var1);

        public Builder options(Consumer<EvaluationFormNumericQuestionOption.Builder> ... var1);

        public Builder automation(EvaluationFormNumericQuestionAutomation var1);

        default public Builder automation(Consumer<EvaluationFormNumericQuestionAutomation.Builder> automation) {
            return this.automation((EvaluationFormNumericQuestionAutomation)((EvaluationFormNumericQuestionAutomation.Builder)EvaluationFormNumericQuestionAutomation.builder().applyMutation(automation)).build());
        }
    }
}

