/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceIdentifier> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResourceIdentifier.getter(ResourceIdentifier::resourceTypeAsString)).setter(ResourceIdentifier.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ResourceIdentifier.getter(ResourceIdentifier::resourceId)).setter(ResourceIdentifier.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(ResourceIdentifier.getter(ResourceIdentifier::resourceName)).setter(ResourceIdentifier.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<Instant> RESOURCE_DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resourceDeletionTime").getter(ResourceIdentifier.getter(ResourceIdentifier::resourceDeletionTime)).setter(ResourceIdentifier.setter(Builder::resourceDeletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDeletionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_DELETION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String resourceId;
    private final String resourceName;
    private final Instant resourceDeletionTime;

    private ResourceIdentifier(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceName = builder.resourceName;
        this.resourceDeletionTime = builder.resourceDeletionTime;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final Instant resourceDeletionTime() {
        return this.resourceDeletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDeletionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceDeletionTime(), other.resourceDeletionTime());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceIdentifier").add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).add("ResourceName", (Object)this.resourceName()).add("ResourceDeletionTime", (Object)this.resourceDeletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceDeletionTime": {
                return Optional.ofNullable(clazz.cast(this.resourceDeletionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String resourceId;
        private String resourceName;
        private Instant resourceDeletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceName(model.resourceName);
            this.resourceDeletionTime(model.resourceDeletionTime);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Instant getResourceDeletionTime() {
            return this.resourceDeletionTime;
        }

        public final void setResourceDeletionTime(Instant resourceDeletionTime) {
            this.resourceDeletionTime = resourceDeletionTime;
        }

        @Override
        public final Builder resourceDeletionTime(Instant resourceDeletionTime) {
            this.resourceDeletionTime = resourceDeletionTime;
            return this;
        }

        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceIdentifier> {
        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceId(String var1);

        public Builder resourceName(String var1);

        public Builder resourceDeletionTime(Instant var1);
    }
}

