/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information for your Config Managed rules and Config Custom Policy rules. The status includes information such
 * as the last time the rule ran, the last time it failed, and the related error for the last failure.
 * </p>
 * <p>
 * This action does not return status information about Config Custom Lambda rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigRuleEvaluationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigRuleEvaluationStatus.Builder, ConfigRuleEvaluationStatus> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(ConfigRuleEvaluationStatus::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> CONFIG_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleArn").getter(getter(ConfigRuleEvaluationStatus::configRuleArn))
            .setter(setter(Builder::configRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleArn").build()).build();

    private static final SdkField<String> CONFIG_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleId").getter(getter(ConfigRuleEvaluationStatus::configRuleId))
            .setter(setter(Builder::configRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleId").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_INVOCATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulInvocationTime")
            .getter(getter(ConfigRuleEvaluationStatus::lastSuccessfulInvocationTime))
            .setter(setter(Builder::lastSuccessfulInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulInvocationTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_FAILED_INVOCATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastFailedInvocationTime")
            .getter(getter(ConfigRuleEvaluationStatus::lastFailedInvocationTime))
            .setter(setter(Builder::lastFailedInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailedInvocationTime").build())
            .build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulEvaluationTime")
            .getter(getter(ConfigRuleEvaluationStatus::lastSuccessfulEvaluationTime))
            .setter(setter(Builder::lastSuccessfulEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulEvaluationTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_FAILED_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastFailedEvaluationTime")
            .getter(getter(ConfigRuleEvaluationStatus::lastFailedEvaluationTime))
            .setter(setter(Builder::lastFailedEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailedEvaluationTime").build())
            .build();

    private static final SdkField<Instant> FIRST_ACTIVATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FirstActivatedTime").getter(getter(ConfigRuleEvaluationStatus::firstActivatedTime))
            .setter(setter(Builder::firstActivatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstActivatedTime").build())
            .build();

    private static final SdkField<Instant> LAST_DEACTIVATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastDeactivatedTime").getter(getter(ConfigRuleEvaluationStatus::lastDeactivatedTime))
            .setter(setter(Builder::lastDeactivatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeactivatedTime").build())
            .build();

    private static final SdkField<String> LAST_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastErrorCode").getter(getter(ConfigRuleEvaluationStatus::lastErrorCode))
            .setter(setter(Builder::lastErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorCode").build()).build();

    private static final SdkField<String> LAST_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastErrorMessage").getter(getter(ConfigRuleEvaluationStatus::lastErrorMessage))
            .setter(setter(Builder::lastErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastErrorMessage").build()).build();

    private static final SdkField<Boolean> FIRST_EVALUATION_STARTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FirstEvaluationStarted").getter(getter(ConfigRuleEvaluationStatus::firstEvaluationStarted))
            .setter(setter(Builder::firstEvaluationStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstEvaluationStarted").build())
            .build();

    private static final SdkField<String> LAST_DEBUG_LOG_DELIVERY_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastDebugLogDeliveryStatus")
            .getter(getter(ConfigRuleEvaluationStatus::lastDebugLogDeliveryStatus))
            .setter(setter(Builder::lastDebugLogDeliveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDebugLogDeliveryStatus").build())
            .build();

    private static final SdkField<String> LAST_DEBUG_LOG_DELIVERY_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastDebugLogDeliveryStatusReason")
            .getter(getter(ConfigRuleEvaluationStatus::lastDebugLogDeliveryStatusReason))
            .setter(setter(Builder::lastDebugLogDeliveryStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDebugLogDeliveryStatusReason")
                    .build()).build();

    private static final SdkField<Instant> LAST_DEBUG_LOG_DELIVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastDebugLogDeliveryTime")
            .getter(getter(ConfigRuleEvaluationStatus::lastDebugLogDeliveryTime))
            .setter(setter(Builder::lastDebugLogDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDebugLogDeliveryTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            CONFIG_RULE_ARN_FIELD, CONFIG_RULE_ID_FIELD, LAST_SUCCESSFUL_INVOCATION_TIME_FIELD,
            LAST_FAILED_INVOCATION_TIME_FIELD, LAST_SUCCESSFUL_EVALUATION_TIME_FIELD, LAST_FAILED_EVALUATION_TIME_FIELD,
            FIRST_ACTIVATED_TIME_FIELD, LAST_DEACTIVATED_TIME_FIELD, LAST_ERROR_CODE_FIELD, LAST_ERROR_MESSAGE_FIELD,
            FIRST_EVALUATION_STARTED_FIELD, LAST_DEBUG_LOG_DELIVERY_STATUS_FIELD, LAST_DEBUG_LOG_DELIVERY_STATUS_REASON_FIELD,
            LAST_DEBUG_LOG_DELIVERY_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String configRuleArn;

    private final String configRuleId;

    private final Instant lastSuccessfulInvocationTime;

    private final Instant lastFailedInvocationTime;

    private final Instant lastSuccessfulEvaluationTime;

    private final Instant lastFailedEvaluationTime;

    private final Instant firstActivatedTime;

    private final Instant lastDeactivatedTime;

    private final String lastErrorCode;

    private final String lastErrorMessage;

    private final Boolean firstEvaluationStarted;

    private final String lastDebugLogDeliveryStatus;

    private final String lastDebugLogDeliveryStatusReason;

    private final Instant lastDebugLogDeliveryTime;

    private ConfigRuleEvaluationStatus(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.configRuleArn = builder.configRuleArn;
        this.configRuleId = builder.configRuleId;
        this.lastSuccessfulInvocationTime = builder.lastSuccessfulInvocationTime;
        this.lastFailedInvocationTime = builder.lastFailedInvocationTime;
        this.lastSuccessfulEvaluationTime = builder.lastSuccessfulEvaluationTime;
        this.lastFailedEvaluationTime = builder.lastFailedEvaluationTime;
        this.firstActivatedTime = builder.firstActivatedTime;
        this.lastDeactivatedTime = builder.lastDeactivatedTime;
        this.lastErrorCode = builder.lastErrorCode;
        this.lastErrorMessage = builder.lastErrorMessage;
        this.firstEvaluationStarted = builder.firstEvaluationStarted;
        this.lastDebugLogDeliveryStatus = builder.lastDebugLogDeliveryStatus;
        this.lastDebugLogDeliveryStatusReason = builder.lastDebugLogDeliveryStatusReason;
        this.lastDebugLogDeliveryTime = builder.lastDebugLogDeliveryTime;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Config rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Config rule.
     */
    public final String configRuleArn() {
        return configRuleArn;
    }

    /**
     * <p>
     * The ID of the Config rule.
     * </p>
     * 
     * @return The ID of the Config rule.
     */
    public final String configRuleId() {
        return configRuleId;
    }

    /**
     * <p>
     * The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services resources.
     * </p>
     * 
     * @return The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services
     *         resources.
     */
    public final Instant lastSuccessfulInvocationTime() {
        return lastSuccessfulInvocationTime;
    }

    /**
     * <p>
     * The time that Config last failed to invoke the Config rule to evaluate your Amazon Web Services resources.
     * </p>
     * 
     * @return The time that Config last failed to invoke the Config rule to evaluate your Amazon Web Services
     *         resources.
     */
    public final Instant lastFailedInvocationTime() {
        return lastFailedInvocationTime;
    }

    /**
     * <p>
     * The time that Config last successfully evaluated your Amazon Web Services resources against the rule.
     * </p>
     * 
     * @return The time that Config last successfully evaluated your Amazon Web Services resources against the rule.
     */
    public final Instant lastSuccessfulEvaluationTime() {
        return lastSuccessfulEvaluationTime;
    }

    /**
     * <p>
     * The time that Config last failed to evaluate your Amazon Web Services resources against the rule.
     * </p>
     * 
     * @return The time that Config last failed to evaluate your Amazon Web Services resources against the rule.
     */
    public final Instant lastFailedEvaluationTime() {
        return lastFailedEvaluationTime;
    }

    /**
     * <p>
     * The time that you first activated the Config rule.
     * </p>
     * 
     * @return The time that you first activated the Config rule.
     */
    public final Instant firstActivatedTime() {
        return firstActivatedTime;
    }

    /**
     * <p>
     * The time that you last turned off the Config rule.
     * </p>
     * 
     * @return The time that you last turned off the Config rule.
     */
    public final Instant lastDeactivatedTime() {
        return lastDeactivatedTime;
    }

    /**
     * <p>
     * The error code that Config returned when the rule last failed.
     * </p>
     * 
     * @return The error code that Config returned when the rule last failed.
     */
    public final String lastErrorCode() {
        return lastErrorCode;
    }

    /**
     * <p>
     * The error message that Config returned when the rule last failed.
     * </p>
     * 
     * @return The error message that Config returned when the rule last failed.
     */
    public final String lastErrorMessage() {
        return lastErrorMessage;
    }

    /**
     * <p>
     * Indicates whether Config has evaluated your resources against the rule at least once.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> - Config has evaluated your Amazon Web Services resources against the rule at least once.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> - Config has not finished evaluating your Amazon Web Services resources against the rule at
     * least once.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether Config has evaluated your resources against the rule at least once.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> - Config has evaluated your Amazon Web Services resources against the rule at least
     *         once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> - Config has not finished evaluating your Amazon Web Services resources against the
     *         rule at least once.
     *         </p>
     *         </li>
     */
    public final Boolean firstEvaluationStarted() {
        return firstEvaluationStarted;
    }

    /**
     * <p>
     * The status of the last attempted delivery of a debug log for your Config Custom Policy rules. Either
     * <code>Successful</code> or <code>Failed</code>.
     * </p>
     * 
     * @return The status of the last attempted delivery of a debug log for your Config Custom Policy rules. Either
     *         <code>Successful</code> or <code>Failed</code>.
     */
    public final String lastDebugLogDeliveryStatus() {
        return lastDebugLogDeliveryStatus;
    }

    /**
     * <p>
     * The reason Config was not able to deliver a debug log. This is for the last failed attempt to retrieve a debug
     * log for your Config Custom Policy rules.
     * </p>
     * 
     * @return The reason Config was not able to deliver a debug log. This is for the last failed attempt to retrieve a
     *         debug log for your Config Custom Policy rules.
     */
    public final String lastDebugLogDeliveryStatusReason() {
        return lastDebugLogDeliveryStatusReason;
    }

    /**
     * <p>
     * The time Config last attempted to deliver a debug log for your Config Custom Policy rules.
     * </p>
     * 
     * @return The time Config last attempted to deliver a debug log for your Config Custom Policy rules.
     */
    public final Instant lastDebugLogDeliveryTime() {
        return lastDebugLogDeliveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(configRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailedInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailedEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(firstActivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeactivatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(firstEvaluationStarted());
        hashCode = 31 * hashCode + Objects.hashCode(lastDebugLogDeliveryStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastDebugLogDeliveryStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastDebugLogDeliveryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigRuleEvaluationStatus)) {
            return false;
        }
        ConfigRuleEvaluationStatus other = (ConfigRuleEvaluationStatus) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(configRuleArn(), other.configRuleArn())
                && Objects.equals(configRuleId(), other.configRuleId())
                && Objects.equals(lastSuccessfulInvocationTime(), other.lastSuccessfulInvocationTime())
                && Objects.equals(lastFailedInvocationTime(), other.lastFailedInvocationTime())
                && Objects.equals(lastSuccessfulEvaluationTime(), other.lastSuccessfulEvaluationTime())
                && Objects.equals(lastFailedEvaluationTime(), other.lastFailedEvaluationTime())
                && Objects.equals(firstActivatedTime(), other.firstActivatedTime())
                && Objects.equals(lastDeactivatedTime(), other.lastDeactivatedTime())
                && Objects.equals(lastErrorCode(), other.lastErrorCode())
                && Objects.equals(lastErrorMessage(), other.lastErrorMessage())
                && Objects.equals(firstEvaluationStarted(), other.firstEvaluationStarted())
                && Objects.equals(lastDebugLogDeliveryStatus(), other.lastDebugLogDeliveryStatus())
                && Objects.equals(lastDebugLogDeliveryStatusReason(), other.lastDebugLogDeliveryStatusReason())
                && Objects.equals(lastDebugLogDeliveryTime(), other.lastDebugLogDeliveryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigRuleEvaluationStatus").add("ConfigRuleName", configRuleName())
                .add("ConfigRuleArn", configRuleArn()).add("ConfigRuleId", configRuleId())
                .add("LastSuccessfulInvocationTime", lastSuccessfulInvocationTime())
                .add("LastFailedInvocationTime", lastFailedInvocationTime())
                .add("LastSuccessfulEvaluationTime", lastSuccessfulEvaluationTime())
                .add("LastFailedEvaluationTime", lastFailedEvaluationTime()).add("FirstActivatedTime", firstActivatedTime())
                .add("LastDeactivatedTime", lastDeactivatedTime()).add("LastErrorCode", lastErrorCode())
                .add("LastErrorMessage", lastErrorMessage()).add("FirstEvaluationStarted", firstEvaluationStarted())
                .add("LastDebugLogDeliveryStatus", lastDebugLogDeliveryStatus())
                .add("LastDebugLogDeliveryStatusReason", lastDebugLogDeliveryStatusReason())
                .add("LastDebugLogDeliveryTime", lastDebugLogDeliveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ConfigRuleArn":
            return Optional.ofNullable(clazz.cast(configRuleArn()));
        case "ConfigRuleId":
            return Optional.ofNullable(clazz.cast(configRuleId()));
        case "LastSuccessfulInvocationTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulInvocationTime()));
        case "LastFailedInvocationTime":
            return Optional.ofNullable(clazz.cast(lastFailedInvocationTime()));
        case "LastSuccessfulEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulEvaluationTime()));
        case "LastFailedEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastFailedEvaluationTime()));
        case "FirstActivatedTime":
            return Optional.ofNullable(clazz.cast(firstActivatedTime()));
        case "LastDeactivatedTime":
            return Optional.ofNullable(clazz.cast(lastDeactivatedTime()));
        case "LastErrorCode":
            return Optional.ofNullable(clazz.cast(lastErrorCode()));
        case "LastErrorMessage":
            return Optional.ofNullable(clazz.cast(lastErrorMessage()));
        case "FirstEvaluationStarted":
            return Optional.ofNullable(clazz.cast(firstEvaluationStarted()));
        case "LastDebugLogDeliveryStatus":
            return Optional.ofNullable(clazz.cast(lastDebugLogDeliveryStatus()));
        case "LastDebugLogDeliveryStatusReason":
            return Optional.ofNullable(clazz.cast(lastDebugLogDeliveryStatusReason()));
        case "LastDebugLogDeliveryTime":
            return Optional.ofNullable(clazz.cast(lastDebugLogDeliveryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigRuleEvaluationStatus, T> g) {
        return obj -> g.apply((ConfigRuleEvaluationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigRuleEvaluationStatus> {
        /**
         * <p>
         * The name of the Config rule.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Config rule.
         * </p>
         * 
         * @param configRuleArn
         *        The Amazon Resource Name (ARN) of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleArn(String configRuleArn);

        /**
         * <p>
         * The ID of the Config rule.
         * </p>
         * 
         * @param configRuleId
         *        The ID of the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleId(String configRuleId);

        /**
         * <p>
         * The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services
         * resources.
         * </p>
         * 
         * @param lastSuccessfulInvocationTime
         *        The time that Config last successfully invoked the Config rule to evaluate your Amazon Web Services
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime);

        /**
         * <p>
         * The time that Config last failed to invoke the Config rule to evaluate your Amazon Web Services resources.
         * </p>
         * 
         * @param lastFailedInvocationTime
         *        The time that Config last failed to invoke the Config rule to evaluate your Amazon Web Services
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailedInvocationTime(Instant lastFailedInvocationTime);

        /**
         * <p>
         * The time that Config last successfully evaluated your Amazon Web Services resources against the rule.
         * </p>
         * 
         * @param lastSuccessfulEvaluationTime
         *        The time that Config last successfully evaluated your Amazon Web Services resources against the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime);

        /**
         * <p>
         * The time that Config last failed to evaluate your Amazon Web Services resources against the rule.
         * </p>
         * 
         * @param lastFailedEvaluationTime
         *        The time that Config last failed to evaluate your Amazon Web Services resources against the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime);

        /**
         * <p>
         * The time that you first activated the Config rule.
         * </p>
         * 
         * @param firstActivatedTime
         *        The time that you first activated the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstActivatedTime(Instant firstActivatedTime);

        /**
         * <p>
         * The time that you last turned off the Config rule.
         * </p>
         * 
         * @param lastDeactivatedTime
         *        The time that you last turned off the Config rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeactivatedTime(Instant lastDeactivatedTime);

        /**
         * <p>
         * The error code that Config returned when the rule last failed.
         * </p>
         * 
         * @param lastErrorCode
         *        The error code that Config returned when the rule last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorCode(String lastErrorCode);

        /**
         * <p>
         * The error message that Config returned when the rule last failed.
         * </p>
         * 
         * @param lastErrorMessage
         *        The error message that Config returned when the rule last failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastErrorMessage(String lastErrorMessage);

        /**
         * <p>
         * Indicates whether Config has evaluated your resources against the rule at least once.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> - Config has evaluated your Amazon Web Services resources against the rule at least once.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> - Config has not finished evaluating your Amazon Web Services resources against the rule
         * at least once.
         * </p>
         * </li>
         * </ul>
         * 
         * @param firstEvaluationStarted
         *        Indicates whether Config has evaluated your resources against the rule at least once.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> - Config has evaluated your Amazon Web Services resources against the rule at least
         *        once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> - Config has not finished evaluating your Amazon Web Services resources against the
         *        rule at least once.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstEvaluationStarted(Boolean firstEvaluationStarted);

        /**
         * <p>
         * The status of the last attempted delivery of a debug log for your Config Custom Policy rules. Either
         * <code>Successful</code> or <code>Failed</code>.
         * </p>
         * 
         * @param lastDebugLogDeliveryStatus
         *        The status of the last attempted delivery of a debug log for your Config Custom Policy rules. Either
         *        <code>Successful</code> or <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDebugLogDeliveryStatus(String lastDebugLogDeliveryStatus);

        /**
         * <p>
         * The reason Config was not able to deliver a debug log. This is for the last failed attempt to retrieve a
         * debug log for your Config Custom Policy rules.
         * </p>
         * 
         * @param lastDebugLogDeliveryStatusReason
         *        The reason Config was not able to deliver a debug log. This is for the last failed attempt to retrieve
         *        a debug log for your Config Custom Policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDebugLogDeliveryStatusReason(String lastDebugLogDeliveryStatusReason);

        /**
         * <p>
         * The time Config last attempted to deliver a debug log for your Config Custom Policy rules.
         * </p>
         * 
         * @param lastDebugLogDeliveryTime
         *        The time Config last attempted to deliver a debug log for your Config Custom Policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDebugLogDeliveryTime(Instant lastDebugLogDeliveryTime);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String configRuleArn;

        private String configRuleId;

        private Instant lastSuccessfulInvocationTime;

        private Instant lastFailedInvocationTime;

        private Instant lastSuccessfulEvaluationTime;

        private Instant lastFailedEvaluationTime;

        private Instant firstActivatedTime;

        private Instant lastDeactivatedTime;

        private String lastErrorCode;

        private String lastErrorMessage;

        private Boolean firstEvaluationStarted;

        private String lastDebugLogDeliveryStatus;

        private String lastDebugLogDeliveryStatusReason;

        private Instant lastDebugLogDeliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigRuleEvaluationStatus model) {
            configRuleName(model.configRuleName);
            configRuleArn(model.configRuleArn);
            configRuleId(model.configRuleId);
            lastSuccessfulInvocationTime(model.lastSuccessfulInvocationTime);
            lastFailedInvocationTime(model.lastFailedInvocationTime);
            lastSuccessfulEvaluationTime(model.lastSuccessfulEvaluationTime);
            lastFailedEvaluationTime(model.lastFailedEvaluationTime);
            firstActivatedTime(model.firstActivatedTime);
            lastDeactivatedTime(model.lastDeactivatedTime);
            lastErrorCode(model.lastErrorCode);
            lastErrorMessage(model.lastErrorMessage);
            firstEvaluationStarted(model.firstEvaluationStarted);
            lastDebugLogDeliveryStatus(model.lastDebugLogDeliveryStatus);
            lastDebugLogDeliveryStatusReason(model.lastDebugLogDeliveryStatusReason);
            lastDebugLogDeliveryTime(model.lastDebugLogDeliveryTime);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getConfigRuleArn() {
            return configRuleArn;
        }

        public final void setConfigRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
        }

        @Override
        public final Builder configRuleArn(String configRuleArn) {
            this.configRuleArn = configRuleArn;
            return this;
        }

        public final String getConfigRuleId() {
            return configRuleId;
        }

        public final void setConfigRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
        }

        @Override
        public final Builder configRuleId(String configRuleId) {
            this.configRuleId = configRuleId;
            return this;
        }

        public final Instant getLastSuccessfulInvocationTime() {
            return lastSuccessfulInvocationTime;
        }

        public final void setLastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
        }

        @Override
        public final Builder lastSuccessfulInvocationTime(Instant lastSuccessfulInvocationTime) {
            this.lastSuccessfulInvocationTime = lastSuccessfulInvocationTime;
            return this;
        }

        public final Instant getLastFailedInvocationTime() {
            return lastFailedInvocationTime;
        }

        public final void setLastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
        }

        @Override
        public final Builder lastFailedInvocationTime(Instant lastFailedInvocationTime) {
            this.lastFailedInvocationTime = lastFailedInvocationTime;
            return this;
        }

        public final Instant getLastSuccessfulEvaluationTime() {
            return lastSuccessfulEvaluationTime;
        }

        public final void setLastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
        }

        @Override
        public final Builder lastSuccessfulEvaluationTime(Instant lastSuccessfulEvaluationTime) {
            this.lastSuccessfulEvaluationTime = lastSuccessfulEvaluationTime;
            return this;
        }

        public final Instant getLastFailedEvaluationTime() {
            return lastFailedEvaluationTime;
        }

        public final void setLastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
        }

        @Override
        public final Builder lastFailedEvaluationTime(Instant lastFailedEvaluationTime) {
            this.lastFailedEvaluationTime = lastFailedEvaluationTime;
            return this;
        }

        public final Instant getFirstActivatedTime() {
            return firstActivatedTime;
        }

        public final void setFirstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
        }

        @Override
        public final Builder firstActivatedTime(Instant firstActivatedTime) {
            this.firstActivatedTime = firstActivatedTime;
            return this;
        }

        public final Instant getLastDeactivatedTime() {
            return lastDeactivatedTime;
        }

        public final void setLastDeactivatedTime(Instant lastDeactivatedTime) {
            this.lastDeactivatedTime = lastDeactivatedTime;
        }

        @Override
        public final Builder lastDeactivatedTime(Instant lastDeactivatedTime) {
            this.lastDeactivatedTime = lastDeactivatedTime;
            return this;
        }

        public final String getLastErrorCode() {
            return lastErrorCode;
        }

        public final void setLastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
        }

        @Override
        public final Builder lastErrorCode(String lastErrorCode) {
            this.lastErrorCode = lastErrorCode;
            return this;
        }

        public final String getLastErrorMessage() {
            return lastErrorMessage;
        }

        public final void setLastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
        }

        @Override
        public final Builder lastErrorMessage(String lastErrorMessage) {
            this.lastErrorMessage = lastErrorMessage;
            return this;
        }

        public final Boolean getFirstEvaluationStarted() {
            return firstEvaluationStarted;
        }

        public final void setFirstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
        }

        @Override
        public final Builder firstEvaluationStarted(Boolean firstEvaluationStarted) {
            this.firstEvaluationStarted = firstEvaluationStarted;
            return this;
        }

        public final String getLastDebugLogDeliveryStatus() {
            return lastDebugLogDeliveryStatus;
        }

        public final void setLastDebugLogDeliveryStatus(String lastDebugLogDeliveryStatus) {
            this.lastDebugLogDeliveryStatus = lastDebugLogDeliveryStatus;
        }

        @Override
        public final Builder lastDebugLogDeliveryStatus(String lastDebugLogDeliveryStatus) {
            this.lastDebugLogDeliveryStatus = lastDebugLogDeliveryStatus;
            return this;
        }

        public final String getLastDebugLogDeliveryStatusReason() {
            return lastDebugLogDeliveryStatusReason;
        }

        public final void setLastDebugLogDeliveryStatusReason(String lastDebugLogDeliveryStatusReason) {
            this.lastDebugLogDeliveryStatusReason = lastDebugLogDeliveryStatusReason;
        }

        @Override
        public final Builder lastDebugLogDeliveryStatusReason(String lastDebugLogDeliveryStatusReason) {
            this.lastDebugLogDeliveryStatusReason = lastDebugLogDeliveryStatusReason;
            return this;
        }

        public final Instant getLastDebugLogDeliveryTime() {
            return lastDebugLogDeliveryTime;
        }

        public final void setLastDebugLogDeliveryTime(Instant lastDebugLogDeliveryTime) {
            this.lastDebugLogDeliveryTime = lastDebugLogDeliveryTime;
        }

        @Override
        public final Builder lastDebugLogDeliveryTime(Instant lastDebugLogDeliveryTime) {
            this.lastDebugLogDeliveryTime = lastDebugLogDeliveryTime;
            return this;
        }

        @Override
        public ConfigRuleEvaluationStatus build() {
            return new ConfigRuleEvaluationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
