/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConformancePackStatusDetail;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;

public class DescribeConformancePackStatusIterable
implements SdkIterable<DescribeConformancePackStatusResponse> {
    private final ConfigClient client;
    private final DescribeConformancePackStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeConformancePackStatusIterable(ConfigClient client, DescribeConformancePackStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeConformancePackStatusResponseFetcher();
    }

    public Iterator<DescribeConformancePackStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConformancePackStatusDetail> conformancePackStatusDetails() {
        Function<DescribeConformancePackStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.conformancePackStatusDetails() != null) {
                return response.conformancePackStatusDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeConformancePackStatusResponseFetcher
    implements SyncPageFetcher<DescribeConformancePackStatusResponse> {
        private DescribeConformancePackStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConformancePackStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeConformancePackStatusResponse nextPage(DescribeConformancePackStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConformancePackStatusIterable.this.client.describeConformancePackStatus(DescribeConformancePackStatusIterable.this.firstRequest);
            }
            return DescribeConformancePackStatusIterable.this.client.describeConformancePackStatus((DescribeConformancePackStatusRequest)((Object)DescribeConformancePackStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

