/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the recording strategy of the configuration recorder.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordingStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<RecordingStrategy.Builder, RecordingStrategy> {
    private static final SdkField<String> USE_ONLY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("useOnly").getter(getter(RecordingStrategy::useOnlyAsString)).setter(setter(Builder::useOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_ONLY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String useOnly;

    private RecordingStrategy(BuilderImpl builder) {
        this.useOnly = builder.useOnly;
    }

    /**
     * <p>
     * The recording strategy for the configuration recorder.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes for all
     * supported regional resource types. You also must set the <code>allSupported</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
     * <code>true</code>.
     * </p>
     * <p>
     * When Config adds support for a new type of regional resource, Config automatically starts recording resources of
     * that type. For a list of supported resource types, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
     * >Supported Resource Types</a> in the <i>Config developer guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for only
     * the resource types that you specify in the <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for all
     * supported resource types, except the resource types that you specify as exemptions to exclude from being recorded
     * in the <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     * >ExclusionByResourceTypes</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
     * <code>true</code>.
     * </p>
     * <p>
     * The <code>recordingStrategy</code> field is optional when you list resource types in the
     * <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     * </p>
     * <p>
     * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the
     * <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     * >ExclusionByResourceTypes</a>.
     * </p>
     * </note> <note>
     * <p>
     * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
     * <code>exclusionByResourceTypes</code> field will override other properties in the request.
     * </p>
     * <p>
     * For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will still
     * be automatically recorded in this option unless those resource types are specifically listed as exemptions in the
     * <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
     * </p>
     * <p>
     * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config adds
     * support for a new resource type in the Region where you set up the configuration recorder, including global
     * resource types, Config starts recording resources of that type automatically.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useOnly} will
     * return {@link RecordingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useOnlyAsString}.
     * </p>
     * 
     * @return The recording strategy for the configuration recorder.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes
     *         for all supported regional resource types. You also must set the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>.
     *         </p>
     *         <p>
     *         When Config adds support for a new type of regional resource, Config automatically starts recording
     *         resources of that type. For a list of supported resource types, see <a href=
     *         "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
     *         >Supported Resource Types</a> in the <i>Config developer guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes
     *         for only the resource types that you specify in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes
     *         for all supported resource types, except the resource types that you specify as exemptions to exclude
     *         from being recorded in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     *         >ExclusionByResourceTypes</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of
     *         <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>.
     *         </p>
     *         <p>
     *         The <code>recordingStrategy</code> field is optional when you list resource types in the
     *         <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         <p>
     *         The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording
     *         in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     *         >ExclusionByResourceTypes</a>.
     *         </p>
     *         </note> <note>
     *         <p>
     *         If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
     *         <code>exclusionByResourceTypes</code> field will override other properties in the request.
     *         </p>
     *         <p>
     *         For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will
     *         still be automatically recorded in this option unless those resource types are specifically listed as
     *         exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
     *         </p>
     *         <p>
     *         By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config
     *         adds support for a new resource type in the Region where you set up the configuration recorder, including
     *         global resource types, Config starts recording resources of that type automatically.
     *         </p>
     * @see RecordingStrategyType
     */
    public final RecordingStrategyType useOnly() {
        return RecordingStrategyType.fromValue(useOnly);
    }

    /**
     * <p>
     * The recording strategy for the configuration recorder.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes for all
     * supported regional resource types. You also must set the <code>allSupported</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
     * <code>true</code>.
     * </p>
     * <p>
     * When Config adds support for a new type of regional resource, Config automatically starts recording resources of
     * that type. For a list of supported resource types, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
     * >Supported Resource Types</a> in the <i>Config developer guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for only
     * the resource types that you specify in the <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for all
     * supported resource types, except the resource types that you specify as exemptions to exclude from being recorded
     * in the <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     * >ExclusionByResourceTypes</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
     * <code>true</code>.
     * </p>
     * <p>
     * The <code>recordingStrategy</code> field is optional when you list resource types in the
     * <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     * </p>
     * <p>
     * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in the
     * <code>resourceTypes</code> field of <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     * >ExclusionByResourceTypes</a>.
     * </p>
     * </note> <note>
     * <p>
     * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
     * <code>exclusionByResourceTypes</code> field will override other properties in the request.
     * </p>
     * <p>
     * For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will still
     * be automatically recorded in this option unless those resource types are specifically listed as exemptions in the
     * <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
     * </p>
     * <p>
     * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config adds
     * support for a new resource type in the Region where you set up the configuration recorder, including global
     * resource types, Config starts recording resources of that type automatically.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useOnly} will
     * return {@link RecordingStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useOnlyAsString}.
     * </p>
     * 
     * @return The recording strategy for the configuration recorder.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes
     *         for all supported regional resource types. You also must set the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>.
     *         </p>
     *         <p>
     *         When Config adds support for a new type of regional resource, Config automatically starts recording
     *         resources of that type. For a list of supported resource types, see <a href=
     *         "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
     *         >Supported Resource Types</a> in the <i>Config developer guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes
     *         for only the resource types that you specify in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes
     *         for all supported resource types, except the resource types that you specify as exemptions to exclude
     *         from being recorded in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     *         >ExclusionByResourceTypes</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of
     *         <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>.
     *         </p>
     *         <p>
     *         The <code>recordingStrategy</code> field is optional when you list resource types in the
     *         <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         <p>
     *         The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording
     *         in the <code>resourceTypes</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
     *         >ExclusionByResourceTypes</a>.
     *         </p>
     *         </note> <note>
     *         <p>
     *         If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
     *         <code>exclusionByResourceTypes</code> field will override other properties in the request.
     *         </p>
     *         <p>
     *         For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will
     *         still be automatically recorded in this option unless those resource types are specifically listed as
     *         exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
     *         </p>
     *         <p>
     *         By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config
     *         adds support for a new resource type in the Region where you set up the configuration recorder, including
     *         global resource types, Config starts recording resources of that type automatically.
     *         </p>
     * @see RecordingStrategyType
     */
    public final String useOnlyAsString() {
        return useOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(useOnlyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingStrategy)) {
            return false;
        }
        RecordingStrategy other = (RecordingStrategy) obj;
        return Objects.equals(useOnlyAsString(), other.useOnlyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordingStrategy").add("UseOnly", useOnlyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "useOnly":
            return Optional.ofNullable(clazz.cast(useOnlyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordingStrategy, T> g) {
        return obj -> g.apply((RecordingStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordingStrategy> {
        /**
         * <p>
         * The recording strategy for the configuration recorder.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes for
         * all supported regional resource types. You also must set the <code>allSupported</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
         * <code>true</code>.
         * </p>
         * <p>
         * When Config adds support for a new type of regional resource, Config automatically starts recording resources
         * of that type. For a list of supported resource types, see <a href=
         * "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
         * >Supported Resource Types</a> in the <i>Config developer guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for
         * only the resource types that you specify in the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for
         * all supported resource types, except the resource types that you specify as exemptions to exclude from being
         * recorded in the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         * >ExclusionByResourceTypes</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
         * <code>true</code>.
         * </p>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you list resource types in the
         * <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         * </p>
         * <p>
         * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in
         * the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         * >ExclusionByResourceTypes</a>.
         * </p>
         * </note> <note>
         * <p>
         * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
         * <code>exclusionByResourceTypes</code> field will override other properties in the request.
         * </p>
         * <p>
         * For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will
         * still be automatically recorded in this option unless those resource types are specifically listed as
         * exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
         * </p>
         * <p>
         * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config adds
         * support for a new resource type in the Region where you set up the configuration recorder, including global
         * resource types, Config starts recording resources of that type automatically.
         * </p>
         * </note>
         * 
         * @param useOnly
         *        The recording strategy for the configuration recorder.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration
         *        changes for all supported regional resource types. You also must set the <code>allSupported</code>
         *        field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup
         *        </a> to <code>true</code>.
         *        </p>
         *        <p>
         *        When Config adds support for a new type of regional resource, Config automatically starts recording
         *        resources of that type. For a list of supported resource types, see <a href=
         *        "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
         *        >Supported Resource Types</a> in the <i>Config developer guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration
         *        changes for only the resource types that you specify in the <code>resourceTypes</code> field of <a
         *        href
         *        ="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration
         *        changes for all supported resource types, except the resource types that you specify as exemptions to
         *        exclude from being recorded in the <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         *        >ExclusionByResourceTypes</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field
         *        of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup
         *        </a> to <code>true</code>.
         *        </p>
         *        <p>
         *        The <code>recordingStrategy</code> field is optional when you list resource types in the
         *        <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html"
         *        >RecordingGroup</a>.
         *        </p>
         *        <p>
         *        The <code>recordingStrategy</code> field is required if you list resource types to exclude from
         *        recording in the <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         *        >ExclusionByResourceTypes</a>.
         *        </p>
         *        </note> <note>
         *        <p>
         *        If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
         *        <code>exclusionByResourceTypes</code> field will override other properties in the request.
         *        </p>
         *        <p>
         *        For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types
         *        will still be automatically recorded in this option unless those resource types are specifically
         *        listed as exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
         *        </p>
         *        <p>
         *        By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config
         *        adds support for a new resource type in the Region where you set up the configuration recorder,
         *        including global resource types, Config starts recording resources of that type automatically.
         *        </p>
         * @see RecordingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingStrategyType
         */
        Builder useOnly(String useOnly);

        /**
         * <p>
         * The recording strategy for the configuration recorder.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration changes for
         * all supported regional resource types. You also must set the <code>allSupported</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
         * <code>true</code>.
         * </p>
         * <p>
         * When Config adds support for a new type of regional resource, Config automatically starts recording resources
         * of that type. For a list of supported resource types, see <a href=
         * "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
         * >Supported Resource Types</a> in the <i>Config developer guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for
         * only the resource types that you specify in the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration changes for
         * all supported resource types, except the resource types that you specify as exemptions to exclude from being
         * recorded in the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         * >ExclusionByResourceTypes</a>.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> to
         * <code>true</code>.
         * </p>
         * <p>
         * The <code>recordingStrategy</code> field is optional when you list resource types in the
         * <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         * </p>
         * <p>
         * The <code>recordingStrategy</code> field is required if you list resource types to exclude from recording in
         * the <code>resourceTypes</code> field of <a
         * href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         * >ExclusionByResourceTypes</a>.
         * </p>
         * </note> <note>
         * <p>
         * If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
         * <code>exclusionByResourceTypes</code> field will override other properties in the request.
         * </p>
         * <p>
         * For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types will
         * still be automatically recorded in this option unless those resource types are specifically listed as
         * exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
         * </p>
         * <p>
         * By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config adds
         * support for a new resource type in the Region where you set up the configuration recorder, including global
         * resource types, Config starts recording resources of that type automatically.
         * </p>
         * </note>
         * 
         * @param useOnly
         *        The recording strategy for the configuration recorder.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you set this option to <code>ALL_SUPPORTED_RESOURCE_TYPES</code>, Config records configuration
         *        changes for all supported regional resource types. You also must set the <code>allSupported</code>
         *        field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup
         *        </a> to <code>true</code>.
         *        </p>
         *        <p>
         *        When Config adds support for a new type of regional resource, Config automatically starts recording
         *        resources of that type. For a list of supported resource types, see <a href=
         *        "https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
         *        >Supported Resource Types</a> in the <i>Config developer guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set this option to <code>INCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration
         *        changes for only the resource types that you specify in the <code>resourceTypes</code> field of <a
         *        href
         *        ="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set this option to <code>EXCLUSION_BY_RESOURCE_TYPES</code>, Config records configuration
         *        changes for all supported resource types, except the resource types that you specify as exemptions to
         *        exclude from being recorded in the <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         *        >ExclusionByResourceTypes</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>recordingStrategy</code> field is optional when you set the <code>allSupported</code> field
         *        of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup
         *        </a> to <code>true</code>.
         *        </p>
         *        <p>
         *        The <code>recordingStrategy</code> field is optional when you list resource types in the
         *        <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html"
         *        >RecordingGroup</a>.
         *        </p>
         *        <p>
         *        The <code>recordingStrategy</code> field is required if you list resource types to exclude from
         *        recording in the <code>resourceTypes</code> field of <a
         *        href="https://docs.aws.amazon.com/config/latest/APIReference/API_ExclusionByResourceTypes.html"
         *        >ExclusionByResourceTypes</a>.
         *        </p>
         *        </note> <note>
         *        <p>
         *        If you choose <code>EXCLUSION_BY_RESOURCE_TYPES</code> for the recording strategy, the
         *        <code>exclusionByResourceTypes</code> field will override other properties in the request.
         *        </p>
         *        <p>
         *        For example, even if you set <code>includeGlobalResourceTypes</code> to false, global resource types
         *        will still be automatically recorded in this option unless those resource types are specifically
         *        listed as exemptions in the <code>resourceTypes</code> field of <code>exclusionByResourceTypes</code>.
         *        </p>
         *        <p>
         *        By default, if you choose the <code>EXCLUSION_BY_RESOURCE_TYPES</code> recording strategy, when Config
         *        adds support for a new resource type in the Region where you set up the configuration recorder,
         *        including global resource types, Config starts recording resources of that type automatically.
         *        </p>
         * @see RecordingStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingStrategyType
         */
        Builder useOnly(RecordingStrategyType useOnly);
    }

    static final class BuilderImpl implements Builder {
        private String useOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingStrategy model) {
            useOnly(model.useOnly);
        }

        public final String getUseOnly() {
            return useOnly;
        }

        public final void setUseOnly(String useOnly) {
            this.useOnly = useOnly;
        }

        @Override
        public final Builder useOnly(String useOnly) {
            this.useOnly = useOnly;
            return this;
        }

        @Override
        public final Builder useOnly(RecordingStrategyType useOnly) {
            this.useOnly(useOnly == null ? null : useOnly.toString());
            return this;
        }

        @Override
        public RecordingStrategy build() {
            return new RecordingStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
