/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationCustomRulePolicyResponse extends ConfigResponse implements
        ToCopyableBuilder<GetOrganizationCustomRulePolicyResponse.Builder, GetOrganizationCustomRulePolicyResponse> {
    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyText").getter(getter(GetOrganizationCustomRulePolicyResponse::policyText))
            .setter(setter(Builder::policyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TEXT_FIELD));

    private final String policyText;

    private GetOrganizationCustomRulePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyText = builder.policyText;
    }

    /**
     * <p>
     * The policy definition containing the logic for your organization Config Custom Policy rule.
     * </p>
     * 
     * @return The policy definition containing the logic for your organization Config Custom Policy rule.
     */
    public final String policyText() {
        return policyText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationCustomRulePolicyResponse)) {
            return false;
        }
        GetOrganizationCustomRulePolicyResponse other = (GetOrganizationCustomRulePolicyResponse) obj;
        return Objects.equals(policyText(), other.policyText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationCustomRulePolicyResponse").add("PolicyText", policyText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyText":
            return Optional.ofNullable(clazz.cast(policyText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationCustomRulePolicyResponse, T> g) {
        return obj -> g.apply((GetOrganizationCustomRulePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationCustomRulePolicyResponse> {
        /**
         * <p>
         * The policy definition containing the logic for your organization Config Custom Policy rule.
         * </p>
         * 
         * @param policyText
         *        The policy definition containing the logic for your organization Config Custom Policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyText(String policyText);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String policyText;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationCustomRulePolicyResponse model) {
            super(model);
            policyText(model.policyText);
        }

        public final String getPolicyText() {
            return policyText;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        @Override
        public GetOrganizationCustomRulePolicyResponse build() {
            return new GetOrganizationCustomRulePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
