/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigRulesResponse extends ConfigResponse implements
        ToCopyableBuilder<DescribeOrganizationConfigRulesResponse.Builder, DescribeOrganizationConfigRulesResponse> {
    private static final SdkField<List<OrganizationConfigRule>> ORGANIZATION_CONFIG_RULES_FIELD = SdkField
            .<List<OrganizationConfigRule>> builder(MarshallingType.LIST)
            .memberName("OrganizationConfigRules")
            .getter(getter(DescribeOrganizationConfigRulesResponse::organizationConfigRules))
            .setter(setter(Builder::organizationConfigRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrganizationConfigRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrganizationConfigRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationConfigRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_CONFIG_RULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<OrganizationConfigRule> organizationConfigRules;

    private final String nextToken;

    private DescribeOrganizationConfigRulesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRules = builder.organizationConfigRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationConfigRules property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationConfigRules() {
        return organizationConfigRules != null && !(organizationConfigRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of <code>OrganizationConfigRule</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationConfigRules} method.
     * </p>
     * 
     * @return Returns a list of <code>OrganizationConfigRule</code> objects.
     */
    public final List<OrganizationConfigRule> organizationConfigRules() {
        return organizationConfigRules;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationConfigRules() ? organizationConfigRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRulesResponse)) {
            return false;
        }
        DescribeOrganizationConfigRulesResponse other = (DescribeOrganizationConfigRulesResponse) obj;
        return hasOrganizationConfigRules() == other.hasOrganizationConfigRules()
                && Objects.equals(organizationConfigRules(), other.organizationConfigRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationConfigRulesResponse")
                .add("OrganizationConfigRules", hasOrganizationConfigRules() ? organizationConfigRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationConfigRules":
            return Optional.ofNullable(clazz.cast(organizationConfigRules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRulesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigRulesResponse> {
        /**
         * <p>
         * Returns a list of <code>OrganizationConfigRule</code> objects.
         * </p>
         * 
         * @param organizationConfigRules
         *        Returns a list of <code>OrganizationConfigRule</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRules(Collection<OrganizationConfigRule> organizationConfigRules);

        /**
         * <p>
         * Returns a list of <code>OrganizationConfigRule</code> objects.
         * </p>
         * 
         * @param organizationConfigRules
         *        Returns a list of <code>OrganizationConfigRule</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationConfigRules(OrganizationConfigRule... organizationConfigRules);

        /**
         * <p>
         * Returns a list of <code>OrganizationConfigRule</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.OrganizationConfigRule.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.config.model.OrganizationConfigRule#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.OrganizationConfigRule.Builder#build()} is called
         * immediately and its result is passed to {@link #organizationConfigRules(List<OrganizationConfigRule>)}.
         * 
         * @param organizationConfigRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.OrganizationConfigRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationConfigRules(java.util.Collection<OrganizationConfigRule>)
         */
        Builder organizationConfigRules(Consumer<OrganizationConfigRule.Builder>... organizationConfigRules);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<OrganizationConfigRule> organizationConfigRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRulesResponse model) {
            super(model);
            organizationConfigRules(model.organizationConfigRules);
            nextToken(model.nextToken);
        }

        public final List<OrganizationConfigRule.Builder> getOrganizationConfigRules() {
            List<OrganizationConfigRule.Builder> result = OrganizationConfigRulesCopier
                    .copyToBuilder(this.organizationConfigRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationConfigRules(Collection<OrganizationConfigRule.BuilderImpl> organizationConfigRules) {
            this.organizationConfigRules = OrganizationConfigRulesCopier.copyFromBuilder(organizationConfigRules);
        }

        @Override
        public final Builder organizationConfigRules(Collection<OrganizationConfigRule> organizationConfigRules) {
            this.organizationConfigRules = OrganizationConfigRulesCopier.copy(organizationConfigRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRules(OrganizationConfigRule... organizationConfigRules) {
            organizationConfigRules(Arrays.asList(organizationConfigRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRules(Consumer<OrganizationConfigRule.Builder>... organizationConfigRules) {
            organizationConfigRules(Stream.of(organizationConfigRules)
                    .map(c -> OrganizationConfigRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConfigRulesResponse build() {
            return new DescribeOrganizationConfigRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
