/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationAggregatorSourcesStatusRequest extends ConfigRequest
        implements
        ToCopyableBuilder<DescribeConfigurationAggregatorSourcesStatusRequest.Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorName")
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<List<String>> UPDATE_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UpdateStatus")
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::updateStatusAsStrings))
            .setter(setter(Builder::updateStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeConfigurationAggregatorSourcesStatusRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, UPDATE_STATUS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private final String configurationAggregatorName;

    private final List<String> updateStatus;

    private final String nextToken;

    private final Integer limit;

    private DescribeConfigurationAggregatorSourcesStatusRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.updateStatus = builder.updateStatus;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public final String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * Filters the status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateStatus} method.
     * </p>
     * 
     * @return Filters the status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     */
    public final List<AggregatedSourceStatusType> updateStatus() {
        return AggregatedSourceStatusTypeListCopier.copyStringToEnum(updateStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpdateStatus() {
        return updateStatus != null && !(updateStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the status type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid value FAILED indicates errors while moving data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value SUCCEEDED indicates the data was successfully moved.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid value OUTDATED indicates the data is not the most recent.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateStatus} method.
     * </p>
     * 
     * @return Filters the status type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid value FAILED indicates errors while moving data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value SUCCEEDED indicates the data was successfully moved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid value OUTDATED indicates the data is not the most recent.
     *         </p>
     *         </li>
     */
    public final List<String> updateStatusAsStrings() {
        return updateStatus;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0,
     * Config uses the default.
     * </p>
     * 
     * @return The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you
     *         specify 0, Config uses the default.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateStatus() ? updateStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationAggregatorSourcesStatusRequest)) {
            return false;
        }
        DescribeConfigurationAggregatorSourcesStatusRequest other = (DescribeConfigurationAggregatorSourcesStatusRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && hasUpdateStatus() == other.hasUpdateStatus()
                && Objects.equals(updateStatusAsStrings(), other.updateStatusAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationAggregatorSourcesStatusRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName())
                .add("UpdateStatus", hasUpdateStatus() ? updateStatusAsStrings() : null).add("NextToken", nextToken())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationAggregatorSourcesStatusRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationAggregatorSourcesStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationAggregatorSourcesStatusRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatusWithStrings(Collection<String> updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatusWithStrings(String... updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(Collection<AggregatedSourceStatusType> updateStatus);

        /**
         * <p>
         * Filters the status type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid value FAILED indicates errors while moving data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value SUCCEEDED indicates the data was successfully moved.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid value OUTDATED indicates the data is not the most recent.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateStatus
         *        Filters the status type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid value FAILED indicates errors while moving data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value SUCCEEDED indicates the data was successfully moved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid value OUTDATED indicates the data is not the most recent.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateStatus(AggregatedSourceStatusType... updateStatus);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you specify 0,
         * Config uses the default.
         * </p>
         * 
         * @param limit
         *        The maximum number of AggregatorSourceStatus returned on each page. The default is maximum. If you
         *        specify 0, Config uses the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private List<String> updateStatus = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationAggregatorSourcesStatusRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            updateStatusWithStrings(model.updateStatus);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final Collection<String> getUpdateStatus() {
            if (updateStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return updateStatus;
        }

        public final void setUpdateStatus(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
        }

        @Override
        public final Builder updateStatusWithStrings(Collection<String> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copy(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatusWithStrings(String... updateStatus) {
            updateStatusWithStrings(Arrays.asList(updateStatus));
            return this;
        }

        @Override
        public final Builder updateStatus(Collection<AggregatedSourceStatusType> updateStatus) {
            this.updateStatus = AggregatedSourceStatusTypeListCopier.copyEnumToString(updateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateStatus(AggregatedSourceStatusType... updateStatus) {
            updateStatus(Arrays.asList(updateStatus));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationAggregatorSourcesStatusRequest build() {
            return new DescribeConfigurationAggregatorSourcesStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
