/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ICD10CMEntityType {
    DX_NAME("DX_NAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ICD10CMEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ICD10CMEntityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMEntityType> knownValues() {
        return Stream.of(ICD10CMEntityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

