/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the sentiment and sentiment score for one mention of an entity.
 * </p>
 * <p>
 * For more information about targeted sentiment, see <a
 * href="https://docs.aws.amazon.com/comprehend/latest/dg/how-targeted-sentiment.html">Targeted sentiment</a> in the
 * <i>Amazon Comprehend Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MentionSentiment implements SdkPojo, Serializable,
        ToCopyableBuilder<MentionSentiment.Builder, MentionSentiment> {
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sentiment").getter(getter(MentionSentiment::sentimentAsString)).setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField
            .<SentimentScore> builder(MarshallingType.SDK_POJO).memberName("SentimentScore")
            .getter(getter(MentionSentiment::sentimentScore)).setter(setter(Builder::sentimentScore))
            .constructor(SentimentScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_FIELD,
            SENTIMENT_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sentiment;

    private final SentimentScore sentimentScore;

    private MentionSentiment(BuilderImpl builder) {
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    /**
     * <p>
     * The sentiment of the mention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment of the mention.
     * @see SentimentType
     */
    public final SentimentType sentiment() {
        return SentimentType.fromValue(sentiment);
    }

    /**
     * <p>
     * The sentiment of the mention.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment of the mention.
     * @see SentimentType
     */
    public final String sentimentAsString() {
        return sentiment;
    }

    /**
     * Returns the value of the SentimentScore property for this object.
     * 
     * @return The value of the SentimentScore property for this object.
     */
    public final SentimentScore sentimentScore() {
        return sentimentScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MentionSentiment)) {
            return false;
        }
        MentionSentiment other = (MentionSentiment) obj;
        return Objects.equals(sentimentAsString(), other.sentimentAsString())
                && Objects.equals(sentimentScore(), other.sentimentScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MentionSentiment").add("Sentiment", sentimentAsString()).add("SentimentScore", sentimentScore())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        case "SentimentScore":
            return Optional.ofNullable(clazz.cast(sentimentScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MentionSentiment, T> g) {
        return obj -> g.apply((MentionSentiment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MentionSentiment> {
        /**
         * <p>
         * The sentiment of the mention.
         * </p>
         * 
         * @param sentiment
         *        The sentiment of the mention.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * The sentiment of the mention.
         * </p>
         * 
         * @param sentiment
         *        The sentiment of the mention.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(SentimentType sentiment);

        /**
         * Sets the value of the SentimentScore property for this object.
         *
         * @param sentimentScore
         *        The new value for the SentimentScore property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentScore(SentimentScore sentimentScore);

        /**
         * Sets the value of the SentimentScore property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SentimentScore.Builder} avoiding the need
         * to create one manually via {@link SentimentScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentScore.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentScore(SentimentScore)}.
         * 
         * @param sentimentScore
         *        a consumer that will call methods on {@link SentimentScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentScore(SentimentScore)
         */
        default Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return sentimentScore(SentimentScore.builder().applyMutation(sentimentScore).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sentiment;

        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(MentionSentiment model) {
            sentiment(model.sentiment);
            sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return sentimentScore != null ? sentimentScore.toBuilder() : null;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        @Override
        public MentionSentiment build() {
            return new MentionSentiment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
