/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssetExtensionType {
    ICO("ICO"),
    JPEG("JPEG"),
    PNG("PNG"),
    SVG("SVG"),
    WEBP("WEBP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssetExtensionType> VALUE_MAP;
    private final String value;

    private AssetExtensionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetExtensionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssetExtensionType> knownValues() {
        EnumSet<AssetExtensionType> knownValues = EnumSet.allOf(AssetExtensionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssetExtensionType.class, AssetExtensionType::toString);
    }
}

