/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeReviewsRequest extends CodeGuruReviewerRequest implements
        ToCopyableBuilder<ListCodeReviewsRequest.Builder, ListCodeReviewsRequest> {
    private static final SdkField<List<String>> PROVIDER_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProviderTypes")
            .getter(getter(ListCodeReviewsRequest::providerTypesAsStrings))
            .setter(setter(Builder::providerTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProviderTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("States")
            .getter(getter(ListCodeReviewsRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("States").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RepositoryNames")
            .getter(getter(ListCodeReviewsRequest::repositoryNames))
            .setter(setter(Builder::repositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RepositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListCodeReviewsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Type").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCodeReviewsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCodeReviewsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPES_FIELD,
            STATES_FIELD, REPOSITORY_NAMES_FIELD, TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> providerTypes;

    private final List<String> states;

    private final List<String> repositoryNames;

    private final String type;

    private final Integer maxResults;

    private final String nextToken;

    private ListCodeReviewsRequest(BuilderImpl builder) {
        super(builder);
        this.providerTypes = builder.providerTypes;
        this.states = builder.states;
        this.repositoryNames = builder.repositoryNames;
        this.type = builder.type;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of provider types for filtering that needs to be applied before displaying the result. For example,
     * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviderTypes} method.
     * </p>
     * 
     * @return List of provider types for filtering that needs to be applied before displaying the result. For example,
     *         <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
     */
    public final List<ProviderType> providerTypes() {
        return ProviderTypesCopier.copyStringToEnum(providerTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ProviderTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProviderTypes() {
        return providerTypes != null && !(providerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of provider types for filtering that needs to be applied before displaying the result. For example,
     * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviderTypes} method.
     * </p>
     * 
     * @return List of provider types for filtering that needs to be applied before displaying the result. For example,
     *         <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
     */
    public final List<String> providerTypesAsStrings() {
        return providerTypes;
    }

    /**
     * <p>
     * List of states for filtering that needs to be applied before displaying the result. For example,
     * <code>states=[Pending]</code> lists code reviews in the Pending state.
     * </p>
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return List of states for filtering that needs to be applied before displaying the result. For example,
     *         <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
     *         <p>
     *         The valid code review states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     */
    public final List<JobState> states() {
        return JobStatesCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of states for filtering that needs to be applied before displaying the result. For example,
     * <code>states=[Pending]</code> lists code reviews in the Pending state.
     * </p>
     * <p>
     * The valid code review states are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Completed</code>: The code review is complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code>: The code review started and has not completed or failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>: The code review failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deleting</code>: The code review is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return List of states for filtering that needs to be applied before displaying the result. For example,
     *         <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
     *         <p>
     *         The valid code review states are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Completed</code>: The code review is complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code>: The code review started and has not completed or failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>: The code review failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deleting</code>: The code review is being deleted.
     *         </p>
     *         </li>
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryNames() {
        return repositoryNames != null && !(repositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of repository names for filtering that needs to be applied before displaying the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryNames} method.
     * </p>
     * 
     * @return List of repository names for filtering that needs to be applied before displaying the result.
     */
    public final List<String> repositoryNames() {
        return repositoryNames;
    }

    /**
     * <p>
     * The type of code reviews to list in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of code reviews to list in the response.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of code reviews to list in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of code reviews to list in the response.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of results that are returned per call. The default is 100.
     * </p>
     * 
     * @return The maximum number of results that are returned per call. The default is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProviderTypes() ? providerTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryNames() ? repositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeReviewsRequest)) {
            return false;
        }
        ListCodeReviewsRequest other = (ListCodeReviewsRequest) obj;
        return hasProviderTypes() == other.hasProviderTypes()
                && Objects.equals(providerTypesAsStrings(), other.providerTypesAsStrings()) && hasStates() == other.hasStates()
                && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && hasRepositoryNames() == other.hasRepositoryNames()
                && Objects.equals(repositoryNames(), other.repositoryNames())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCodeReviewsRequest")
                .add("ProviderTypes", hasProviderTypes() ? providerTypesAsStrings() : null)
                .add("States", hasStates() ? statesAsStrings() : null)
                .add("RepositoryNames", hasRepositoryNames() ? repositoryNames() : null).add("Type", typeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderTypes":
            return Optional.ofNullable(clazz.cast(providerTypesAsStrings()));
        case "States":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "RepositoryNames":
            return Optional.ofNullable(clazz.cast(repositoryNames()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeReviewsRequest, T> g) {
        return obj -> g.apply((ListCodeReviewsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruReviewerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCodeReviewsRequest> {
        /**
         * <p>
         * List of provider types for filtering that needs to be applied before displaying the result. For example,
         * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types for filtering that needs to be applied before displaying the result. For
         *        example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypesWithStrings(Collection<String> providerTypes);

        /**
         * <p>
         * List of provider types for filtering that needs to be applied before displaying the result. For example,
         * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types for filtering that needs to be applied before displaying the result. For
         *        example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypesWithStrings(String... providerTypes);

        /**
         * <p>
         * List of provider types for filtering that needs to be applied before displaying the result. For example,
         * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types for filtering that needs to be applied before displaying the result. For
         *        example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(Collection<ProviderType> providerTypes);

        /**
         * <p>
         * List of provider types for filtering that needs to be applied before displaying the result. For example,
         * <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * </p>
         * 
         * @param providerTypes
         *        List of provider types for filtering that needs to be applied before displaying the result. For
         *        example, <code>providerTypes=[GitHub]</code> lists code reviews from GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(ProviderType... providerTypes);

        /**
         * <p>
         * List of states for filtering that needs to be applied before displaying the result. For example,
         * <code>states=[Pending]</code> lists code reviews in the Pending state.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of states for filtering that needs to be applied before displaying the result. For example,
         *        <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * List of states for filtering that needs to be applied before displaying the result. For example,
         * <code>states=[Pending]</code> lists code reviews in the Pending state.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of states for filtering that needs to be applied before displaying the result. For example,
         *        <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * List of states for filtering that needs to be applied before displaying the result. For example,
         * <code>states=[Pending]</code> lists code reviews in the Pending state.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of states for filtering that needs to be applied before displaying the result. For example,
         *        <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<JobState> states);

        /**
         * <p>
         * List of states for filtering that needs to be applied before displaying the result. For example,
         * <code>states=[Pending]</code> lists code reviews in the Pending state.
         * </p>
         * <p>
         * The valid code review states are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Completed</code>: The code review is complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code>: The code review started and has not completed or failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>: The code review failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deleting</code>: The code review is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param states
         *        List of states for filtering that needs to be applied before displaying the result. For example,
         *        <code>states=[Pending]</code> lists code reviews in the Pending state.</p>
         *        <p>
         *        The valid code review states are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Completed</code>: The code review is complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code>: The code review started and has not completed or failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>: The code review failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deleting</code>: The code review is being deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(JobState... states);

        /**
         * <p>
         * List of repository names for filtering that needs to be applied before displaying the result.
         * </p>
         * 
         * @param repositoryNames
         *        List of repository names for filtering that needs to be applied before displaying the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(Collection<String> repositoryNames);

        /**
         * <p>
         * List of repository names for filtering that needs to be applied before displaying the result.
         * </p>
         * 
         * @param repositoryNames
         *        List of repository names for filtering that needs to be applied before displaying the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(String... repositoryNames);

        /**
         * <p>
         * The type of code reviews to list in the response.
         * </p>
         * 
         * @param type
         *        The type of code reviews to list in the response.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of code reviews to list in the response.
         * </p>
         * 
         * @param type
         *        The type of code reviews to list in the response.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * The maximum number of results that are returned per call. The default is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned per call. The default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruReviewerRequest.BuilderImpl implements Builder {
        private List<String> providerTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeReviewsRequest model) {
            super(model);
            providerTypesWithStrings(model.providerTypes);
            statesWithStrings(model.states);
            repositoryNames(model.repositoryNames);
            type(model.type);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getProviderTypes() {
            if (providerTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return providerTypes;
        }

        public final void setProviderTypes(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
        }

        @Override
        public final Builder providerTypesWithStrings(Collection<String> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypesWithStrings(String... providerTypes) {
            providerTypesWithStrings(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        public final Builder providerTypes(Collection<ProviderType> providerTypes) {
            this.providerTypes = ProviderTypesCopier.copyEnumToString(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(ProviderType... providerTypes) {
            providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobState> states) {
            this.states = JobStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final Collection<String> getRepositoryNames() {
            if (repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoryNames;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNamesCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String... repositoryNames) {
            repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCodeReviewsRequest build() {
            return new ListCodeReviewsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
