/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.internal.UserAgentUtils;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListCodeReviewsResponse;

public class ListCodeReviewsPublisher
implements SdkPublisher<ListCodeReviewsResponse> {
    private final CodeGuruReviewerAsyncClient client;
    private final ListCodeReviewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCodeReviewsPublisher(CodeGuruReviewerAsyncClient client, ListCodeReviewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCodeReviewsPublisher(CodeGuruReviewerAsyncClient client, ListCodeReviewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCodeReviewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCodeReviewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCodeReviewsResponseFetcher
    implements AsyncPageFetcher<ListCodeReviewsResponse> {
        private ListCodeReviewsResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeReviewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCodeReviewsResponse> nextPage(ListCodeReviewsResponse previousPage) {
            if (previousPage == null) {
                return ListCodeReviewsPublisher.this.client.listCodeReviews(ListCodeReviewsPublisher.this.firstRequest);
            }
            return ListCodeReviewsPublisher.this.client.listCodeReviews((ListCodeReviewsRequest)((Object)ListCodeReviewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

