/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.EventInfo;
import software.amazon.awssdk.services.codegurureviewer.model.VendorName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestMetadata> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(RequestMetadata.getter(RequestMetadata::requestId)).setter(RequestMetadata.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> REQUESTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Requester").getter(RequestMetadata.getter(RequestMetadata::requester)).setter(RequestMetadata.setter(Builder::requester)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requester").build()}).build();
    private static final SdkField<EventInfo> EVENT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventInfo").getter(RequestMetadata.getter(RequestMetadata::eventInfo)).setter(RequestMetadata.setter(Builder::eventInfo)).constructor(EventInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInfo").build()}).build();
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VendorName").getter(RequestMetadata.getter(RequestMetadata::vendorNameAsString)).setter(RequestMetadata.setter(Builder::vendorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, REQUESTER_FIELD, EVENT_INFO_FIELD, VENDOR_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String requestId;
    private final String requester;
    private final EventInfo eventInfo;
    private final String vendorName;

    private RequestMetadata(BuilderImpl builder) {
        this.requestId = builder.requestId;
        this.requester = builder.requester;
        this.eventInfo = builder.eventInfo;
        this.vendorName = builder.vendorName;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String requester() {
        return this.requester;
    }

    public final EventInfo eventInfo() {
        return this.eventInfo;
    }

    public final VendorName vendorName() {
        return VendorName.fromValue(this.vendorName);
    }

    public final String vendorNameAsString() {
        return this.vendorName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requester());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadata)) {
            return false;
        }
        RequestMetadata other = (RequestMetadata)obj;
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.requester(), other.requester()) && Objects.equals(this.eventInfo(), other.eventInfo()) && Objects.equals(this.vendorNameAsString(), other.vendorNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RequestMetadata").add("RequestId", (Object)this.requestId()).add("Requester", (Object)this.requester()).add("EventInfo", (Object)this.eventInfo()).add("VendorName", (Object)this.vendorNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Requester": {
                return Optional.ofNullable(clazz.cast(this.requester()));
            }
            case "EventInfo": {
                return Optional.ofNullable(clazz.cast(this.eventInfo()));
            }
            case "VendorName": {
                return Optional.ofNullable(clazz.cast(this.vendorNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadata, T> g) {
        return obj -> g.apply((RequestMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestId;
        private String requester;
        private EventInfo eventInfo;
        private String vendorName;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadata model) {
            this.requestId(model.requestId);
            this.requester(model.requester);
            this.eventInfo(model.eventInfo);
            this.vendorName(model.vendorName);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getRequester() {
            return this.requester;
        }

        public final void setRequester(String requester) {
            this.requester = requester;
        }

        @Override
        public final Builder requester(String requester) {
            this.requester = requester;
            return this;
        }

        public final EventInfo.Builder getEventInfo() {
            return this.eventInfo != null ? this.eventInfo.toBuilder() : null;
        }

        public final void setEventInfo(EventInfo.BuilderImpl eventInfo) {
            this.eventInfo = eventInfo != null ? eventInfo.build() : null;
        }

        @Override
        public final Builder eventInfo(EventInfo eventInfo) {
            this.eventInfo = eventInfo;
            return this;
        }

        public final String getVendorName() {
            return this.vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        @Override
        public final Builder vendorName(VendorName vendorName) {
            this.vendorName(vendorName == null ? null : vendorName.toString());
            return this;
        }

        public RequestMetadata build() {
            return new RequestMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestMetadata> {
        public Builder requestId(String var1);

        public Builder requester(String var1);

        public Builder eventInfo(EventInfo var1);

        default public Builder eventInfo(Consumer<EventInfo.Builder> eventInfo) {
            return this.eventInfo((EventInfo)((EventInfo.Builder)EventInfo.builder().applyMutation(eventInfo)).build());
        }

        public Builder vendorName(String var1);

        public Builder vendorName(VendorName var1);
    }
}

