/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.endpoints.EndpointProvider;

public class EndpointProviderInterfaceSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointProviderInterfaceSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.className()).addSuperinterface(EndpointProvider.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(SdkPublicApi.class).addJavadoc(this.interfaceJavadoc()).addMethod(this.resolveEndpointMethod()).addMethod(this.resolveEndpointConsumerBuilderMethod()).addMethod(this.defaultProviderMethod()).build();
    }

    private MethodSpec resolveEndpointMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveEndpoint");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        b.addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), "endpointParams", new Modifier[0]);
        b.returns(this.endpointRulesSpecUtils.resolverReturnType());
        b.addJavadoc(this.resolveMethodJavadoc());
        return b.build();
    }

    private MethodSpec resolveEndpointConsumerBuilderMethod() {
        ClassName parametersClass = this.endpointRulesSpecUtils.parametersClassName();
        ClassName parametersBuilderClass = parametersClass.nestedClass("Builder");
        ParameterizedTypeName consumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{parametersBuilderClass});
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveEndpoint");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
        b.addParameter((TypeName)consumerType, "endpointParamsConsumer", new Modifier[0]);
        b.returns(this.endpointRulesSpecUtils.resolverReturnType());
        b.addJavadoc(this.resolveMethodJavadoc());
        b.addStatement("$T paramsBuilder = $T.builder()", new Object[]{parametersBuilderClass, parametersClass});
        b.addStatement("endpointParamsConsumer.accept(paramsBuilder)", new Object[0]);
        b.addStatement("return resolveEndpoint(paramsBuilder.build())", new Object[0]);
        return b.build();
    }

    private MethodSpec defaultProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultProvider").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.className()).addStatement("return new $T()", new Object[]{this.endpointRulesSpecUtils.providerDefaultImplName()}).build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.providerInterfaceName();
    }

    private CodeBlock interfaceJavadoc() {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("An endpoint provider for $N. The endpoint provider takes a set of parameters using {@link $T}, and resolves an {@link $T} base on the given parameters.", new Object[]{this.intermediateModel.getMetadata().getServiceName(), this.endpointRulesSpecUtils.parametersClassName(), Endpoint.class});
        return b.build();
    }

    private CodeBlock resolveMethodJavadoc() {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("Compute the endpoint based on the given set of parameters.", new Object[0]);
        return b.build();
    }
}

