/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.utils.IoUtils;

public final class SdkClientConfigurationUtilGeneratorTask
extends BaseGeneratorTasks {
    public static final String RUNTIME_CLASS_NAME = "SdkClientConfigurationUtil";
    private final String internalPackage;
    private final String internalClassDir;
    private final String fileHeader;
    private final String runtimeClassCode;

    public SdkClientConfigurationUtilGeneratorTask(GeneratorTaskParams generatorTaskParams) {
        super(generatorTaskParams);
        this.internalPackage = this.model.getMetadata().getFullClientInternalPackageName();
        this.internalClassDir = generatorTaskParams.getPathProvider().getClientInternalDirectory();
        this.fileHeader = generatorTaskParams.getModel().getFileHeader();
        this.runtimeClassCode = SdkClientConfigurationUtilGeneratorTask.loadConfigUtilCode();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        String codeContents = "package " + this.internalPackage + ";\n\n" + this.runtimeClassCode;
        String fileName = "SdkClientConfigurationUtil.java";
        return Collections.singletonList(new SimpleGeneratorTask(this.internalClassDir, fileName, this.fileHeader, () -> codeContents));
    }

    private static String loadConfigUtilCode() {
        try {
            InputStream is = SdkClientConfigurationUtilGeneratorTask.class.getResourceAsStream("/software/amazon/awssdk/codegen/poet/model/SdkClientConfigurationUtil.java.resource");
            return IoUtils.toUtf8String((InputStream)is);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

