/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateDeployment</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends CodeDeployRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(CreateDeploymentRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentGroupName").getter(getter(CreateDeploymentRequest::deploymentGroupName))
            .setter(setter(Builder::deploymentGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build())
            .build();

    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField
            .<RevisionLocation> builder(MarshallingType.SDK_POJO).memberName("revision")
            .getter(getter(CreateDeploymentRequest::revision)).setter(setter(Builder::revision))
            .constructor(RevisionLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentConfigName").getter(getter(CreateDeploymentRequest::deploymentConfigName))
            .setter(setter(Builder::deploymentConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDeploymentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IGNORE_APPLICATION_STOP_FAILURES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreApplicationStopFailures")
            .getter(getter(CreateDeploymentRequest::ignoreApplicationStopFailures))
            .setter(setter(Builder::ignoreApplicationStopFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreApplicationStopFailures")
                    .build()).build();

    private static final SdkField<TargetInstances> TARGET_INSTANCES_FIELD = SdkField
            .<TargetInstances> builder(MarshallingType.SDK_POJO).memberName("targetInstances")
            .getter(getter(CreateDeploymentRequest::targetInstances)).setter(setter(Builder::targetInstances))
            .constructor(TargetInstances::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstances").build()).build();

    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfiguration> builder(MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration")
            .getter(getter(CreateDeploymentRequest::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build())
            .build();

    private static final SdkField<Boolean> UPDATE_OUTDATED_INSTANCES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("updateOutdatedInstancesOnly")
            .getter(getter(CreateDeploymentRequest::updateOutdatedInstancesOnly))
            .setter(setter(Builder::updateOutdatedInstancesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateOutdatedInstancesOnly")
                    .build()).build();

    private static final SdkField<String> FILE_EXISTS_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileExistsBehavior").getter(getter(CreateDeploymentRequest::fileExistsBehaviorAsString))
            .setter(setter(Builder::fileExistsBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExistsBehavior").build())
            .build();

    private static final SdkField<AlarmConfiguration> OVERRIDE_ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("overrideAlarmConfiguration")
            .getter(getter(CreateDeploymentRequest::overrideAlarmConfiguration))
            .setter(setter(Builder::overrideAlarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideAlarmConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            DEPLOYMENT_GROUP_NAME_FIELD, REVISION_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, DESCRIPTION_FIELD,
            IGNORE_APPLICATION_STOP_FAILURES_FIELD, TARGET_INSTANCES_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD,
            UPDATE_OUTDATED_INSTANCES_ONLY_FIELD, FILE_EXISTS_BEHAVIOR_FIELD, OVERRIDE_ALARM_CONFIGURATION_FIELD));

    private final String applicationName;

    private final String deploymentGroupName;

    private final RevisionLocation revision;

    private final String deploymentConfigName;

    private final String description;

    private final Boolean ignoreApplicationStopFailures;

    private final TargetInstances targetInstances;

    private final AutoRollbackConfiguration autoRollbackConfiguration;

    private final Boolean updateOutdatedInstancesOnly;

    private final String fileExistsBehavior;

    private final AlarmConfiguration overrideAlarmConfiguration;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
        this.overrideAlarmConfiguration = builder.overrideAlarmConfiguration;
    }

    /**
     * <p>
     * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     * </p>
     * 
     * @return The name of an CodeDeploy application associated with the user or Amazon Web Services account.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The name of the deployment group.
     * </p>
     * 
     * @return The name of the deployment group.
     */
    public final String deploymentGroupName() {
        return deploymentGroupName;
    }

    /**
     * <p>
     * The type and location of the revision to deploy.
     * </p>
     * 
     * @return The type and location of the revision to deploy.
     */
    public final RevisionLocation revision() {
        return revision;
    }

    /**
     * <p>
     * The name of a deployment configuration associated with the user or Amazon Web Services account.
     * </p>
     * <p>
     * If not specified, the value configured in the deployment group is used as the default. If the deployment group
     * does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.
     * <code>OneAtATime</code> is used by default.
     * </p>
     * 
     * @return The name of a deployment configuration associated with the user or Amazon Web Services account.</p>
     *         <p>
     *         If not specified, the value configured in the deployment group is used as the default. If the deployment
     *         group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.
     *         <code>OneAtATime</code> is used by default.
     */
    public final String deploymentConfigName() {
        return deploymentConfigName;
    }

    /**
     * <p>
     * A comment about the deployment.
     * </p>
     * 
     * @return A comment about the deployment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
     * <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues to
     * the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment continues
     * with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment continues with
     * <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues with
     * <code>ApplicationStop</code>.
     * </p>
     * <p>
     * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment
     * fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not
     * less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
     * </p>
     * <p>
     * During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
     * <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous
     * successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of
     * these scripts contains an error and does not run successfully, the deployment can fail.
     * </p>
     * <p>
     * If the cause of the failure is a script from the last successful deployment that will never run successfully,
     * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the
     * <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures should
     * be ignored.
     * </p>
     * 
     * @return If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
     *         <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment
     *         continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the
     *         deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the
     *         deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the
     *         deployment continues with <code>ApplicationStop</code>. </p>
     *         <p>
     *         If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
     *         deployment fails. If deployment to that instance is part of an overall deployment and the number of
     *         healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
     *         instance is attempted.
     *         </p>
     *         <p>
     *         During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
     *         <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous
     *         successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If
     *         one of these scripts contains an error and does not run successfully, the deployment can fail.
     *         </p>
     *         <p>
     *         If the cause of the failure is a script from the last successful deployment that will never run
     *         successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that
     *         the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code>
     *         failures should be ignored.
     */
    public final Boolean ignoreApplicationStopFailures() {
        return ignoreApplicationStopFailures;
    }

    /**
     * <p>
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     * </p>
     * 
     * @return Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public final TargetInstances targetInstances() {
        return targetInstances;
    }

    /**
     * <p>
     * Configuration information for an automatic rollback that is added when a deployment is created.
     * </p>
     * 
     * @return Configuration information for an automatic rollback that is added when a deployment is created.
     */
    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    /**
     * <p>
     * Indicates whether to deploy to all instances or only to instances that are not running the latest application
     * revision.
     * </p>
     * 
     * @return Indicates whether to deploy to all instances or only to instances that are not running the latest
     *         application revision.
     */
    public final Boolean updateOutdatedInstancesOnly() {
        return updateOutdatedInstancesOnly;
    }

    /**
     * <p>
     * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <p>
     * The <code>fileExistsBehavior</code> parameter takes any of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <p>
     *         The <code>fileExistsBehavior</code> parameter takes any of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public final FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(fileExistsBehavior);
    }

    /**
     * <p>
     * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't
     * part of the previous successful deployment.
     * </p>
     * <p>
     * The <code>fileExistsBehavior</code> parameter takes any of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE: The version of the file from the application revision currently being deployed replaces the version
     * already on the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fileExistsBehavior} will return {@link FileExistsBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #fileExistsBehaviorAsString}.
     * </p>
     * 
     * @return Information about how CodeDeploy handles files that already exist in a deployment target location but
     *         weren't part of the previous successful deployment.</p>
     *         <p>
     *         The <code>fileExistsBehavior</code> parameter takes any of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE: The version of the file from the application revision currently being deployed replaces the
     *         version already on the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     *         </p>
     *         </li>
     * @see FileExistsBehavior
     */
    public final String fileExistsBehaviorAsString() {
        return fileExistsBehavior;
    }

    /**
     * <p>
     * Allows you to specify information about alarms associated with a deployment. The alarm configuration that you
     * specify here will override the alarm configuration at the deployment group level. Consider overriding the alarm
     * configuration if you have set up alarms at the deployment group level that are causing deployment failures. In
     * this case, you would call <code>CreateDeployment</code> to create a new deployment that uses a previous
     * application revision that is known to work, and set its alarm configuration to turn off alarm polling. Turning
     * off alarm polling ensures that the new deployment proceeds without being blocked by the alarm that was generated
     * by the previous, failed, deployment.
     * </p>
     * <note>
     * <p>
     * If you specify an <code>overrideAlarmConfiguration</code>, you need the <code>UpdateDeploymentGroup</code> IAM
     * permission when calling <code>CreateDeployment</code>.
     * </p>
     * </note>
     * 
     * @return Allows you to specify information about alarms associated with a deployment. The alarm configuration that
     *         you specify here will override the alarm configuration at the deployment group level. Consider overriding
     *         the alarm configuration if you have set up alarms at the deployment group level that are causing
     *         deployment failures. In this case, you would call <code>CreateDeployment</code> to create a new
     *         deployment that uses a previous application revision that is known to work, and set its alarm
     *         configuration to turn off alarm polling. Turning off alarm polling ensures that the new deployment
     *         proceeds without being blocked by the alarm that was generated by the previous, failed, deployment.</p>
     *         <note>
     *         <p>
     *         If you specify an <code>overrideAlarmConfiguration</code>, you need the
     *         <code>UpdateDeploymentGroup</code> IAM permission when calling <code>CreateDeployment</code>.
     *         </p>
     */
    public final AlarmConfiguration overrideAlarmConfiguration() {
        return overrideAlarmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(fileExistsBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(overrideAlarmConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(deploymentGroupName(), other.deploymentGroupName())
                && Objects.equals(revision(), other.revision())
                && Objects.equals(deploymentConfigName(), other.deploymentConfigName())
                && Objects.equals(description(), other.description())
                && Objects.equals(ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures())
                && Objects.equals(targetInstances(), other.targetInstances())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration())
                && Objects.equals(updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly())
                && Objects.equals(fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString())
                && Objects.equals(overrideAlarmConfiguration(), other.overrideAlarmConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentRequest").add("ApplicationName", applicationName())
                .add("DeploymentGroupName", deploymentGroupName()).add("Revision", revision())
                .add("DeploymentConfigName", deploymentConfigName()).add("Description", description())
                .add("IgnoreApplicationStopFailures", ignoreApplicationStopFailures()).add("TargetInstances", targetInstances())
                .add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .add("UpdateOutdatedInstancesOnly", updateOutdatedInstancesOnly())
                .add("FileExistsBehavior", fileExistsBehaviorAsString())
                .add("OverrideAlarmConfiguration", overrideAlarmConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "deploymentGroupName":
            return Optional.ofNullable(clazz.cast(deploymentGroupName()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "deploymentConfigName":
            return Optional.ofNullable(clazz.cast(deploymentConfigName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ignoreApplicationStopFailures":
            return Optional.ofNullable(clazz.cast(ignoreApplicationStopFailures()));
        case "targetInstances":
            return Optional.ofNullable(clazz.cast(targetInstances()));
        case "autoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        case "updateOutdatedInstancesOnly":
            return Optional.ofNullable(clazz.cast(updateOutdatedInstancesOnly()));
        case "fileExistsBehavior":
            return Optional.ofNullable(clazz.cast(fileExistsBehaviorAsString()));
        case "overrideAlarmConfiguration":
            return Optional.ofNullable(clazz.cast(overrideAlarmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeDeployRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * </p>
         * 
         * @param applicationName
         *        The name of an CodeDeploy application associated with the user or Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The name of the deployment group.
         * </p>
         * 
         * @param deploymentGroupName
         *        The name of the deployment group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentGroupName(String deploymentGroupName);

        /**
         * <p>
         * The type and location of the revision to deploy.
         * </p>
         * 
         * @param revision
         *        The type and location of the revision to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(RevisionLocation revision);

        /**
         * <p>
         * The type and location of the revision to deploy.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevisionLocation.Builder} avoiding the
         * need to create one manually via {@link RevisionLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RevisionLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #revision(RevisionLocation)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link RevisionLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(RevisionLocation)
         */
        default Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return revision(RevisionLocation.builder().applyMutation(revision).build());
        }

        /**
         * <p>
         * The name of a deployment configuration associated with the user or Amazon Web Services account.
         * </p>
         * <p>
         * If not specified, the value configured in the deployment group is used as the default. If the deployment
         * group does not have a deployment configuration associated with it, <code>CodeDeployDefault</code>.
         * <code>OneAtATime</code> is used by default.
         * </p>
         * 
         * @param deploymentConfigName
         *        The name of a deployment configuration associated with the user or Amazon Web Services account.</p>
         *        <p>
         *        If not specified, the value configured in the deployment group is used as the default. If the
         *        deployment group does not have a deployment configuration associated with it,
         *        <code>CodeDeployDefault</code>.<code>OneAtATime</code> is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfigName(String deploymentConfigName);

        /**
         * <p>
         * A comment about the deployment.
         * </p>
         * 
         * @param description
         *        A comment about the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
         * <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment continues
         * to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails, the deployment
         * continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails, the deployment
         * continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the deployment continues
         * with <code>ApplicationStop</code>.
         * </p>
         * <p>
         * If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         * deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy
         * hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is
         * attempted.
         * </p>
         * <p>
         * During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
         * <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the previous
         * successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of
         * these scripts contains an error and does not run successfully, the deployment can fail.
         * </p>
         * <p>
         * If the cause of the failure is a script from the last successful deployment that will never run successfully,
         * create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify that the
         * <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> failures
         * should be ignored.
         * </p>
         * 
         * @param ignoreApplicationStopFailures
         *        If true, then if an <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, or
         *        <code>AfterBlockTraffic</code> deployment lifecycle event to an instance fails, then the deployment
         *        continues to the next deployment lifecycle event. For example, if <code>ApplicationStop</code> fails,
         *        the deployment continues with <code>DownloadBundle</code>. If <code>BeforeBlockTraffic</code> fails,
         *        the deployment continues with <code>BlockTraffic</code>. If <code>AfterBlockTraffic</code> fails, the
         *        deployment continues with <code>ApplicationStop</code>. </p>
         *        <p>
         *        If false or not specified, then if a lifecycle event fails during a deployment to an instance, that
         *        deployment fails. If deployment to that instance is part of an overall deployment and the number of
         *        healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next
         *        instance is attempted.
         *        </p>
         *        <p>
         *        During a deployment, the CodeDeploy agent runs the scripts specified for <code>ApplicationStop</code>,
         *        <code>BeforeBlockTraffic</code>, and <code>AfterBlockTraffic</code> in the AppSpec file from the
         *        previous successful deployment. (All other scripts are run from the AppSpec file in the current
         *        deployment.) If one of these scripts contains an error and does not run successfully, the deployment
         *        can fail.
         *        </p>
         *        <p>
         *        If the cause of the failure is a script from the last successful deployment that will never run
         *        successfully, create a new deployment and use <code>ignoreApplicationStopFailures</code> to specify
         *        that the <code>ApplicationStop</code>, <code>BeforeBlockTraffic</code>, and
         *        <code>AfterBlockTraffic</code> failures should be ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * 
         * @param targetInstances
         *        Information about the instances that belong to the replacement environment in a blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstances targetInstances);

        /**
         * <p>
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetInstances.Builder} avoiding the
         * need to create one manually via {@link TargetInstances#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetInstances.Builder#build()} is called immediately and its
         * result is passed to {@link #targetInstances(TargetInstances)}.
         * 
         * @param targetInstances
         *        a consumer that will call methods on {@link TargetInstances.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetInstances(TargetInstances)
         */
        default Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return targetInstances(TargetInstances.builder().applyMutation(targetInstances).build());
        }

        /**
         * <p>
         * Configuration information for an automatic rollback that is added when a deployment is created.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Configuration information for an automatic rollback that is added when a deployment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration);

        /**
         * <p>
         * Configuration information for an automatic rollback that is added when a deployment is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoRollbackConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoRollbackConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfiguration)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfiguration)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration).build());
        }

        /**
         * <p>
         * Indicates whether to deploy to all instances or only to instances that are not running the latest application
         * revision.
         * </p>
         * 
         * @param updateOutdatedInstancesOnly
         *        Indicates whether to deploy to all instances or only to instances that are not running the latest
         *        application revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly);

        /**
         * <p>
         * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't
         * part of the previous successful deployment.
         * </p>
         * <p>
         * The <code>fileExistsBehavior</code> parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how CodeDeploy handles files that already exist in a deployment target location but
         *        weren't part of the previous successful deployment.</p>
         *        <p>
         *        The <code>fileExistsBehavior</code> parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(String fileExistsBehavior);

        /**
         * <p>
         * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't
         * part of the previous successful deployment.
         * </p>
         * <p>
         * The <code>fileExistsBehavior</code> parameter takes any of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         * version already on the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param fileExistsBehavior
         *        Information about how CodeDeploy handles files that already exist in a deployment target location but
         *        weren't part of the previous successful deployment.</p>
         *        <p>
         *        The <code>fileExistsBehavior</code> parameter takes any of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE: The version of the file from the application revision currently being deployed replaces the
         *        version already on the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RETAIN: The version of the file already on the instance is kept and used as part of the new
         *        deployment.
         *        </p>
         *        </li>
         * @see FileExistsBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileExistsBehavior
         */
        Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior);

        /**
         * <p>
         * Allows you to specify information about alarms associated with a deployment. The alarm configuration that you
         * specify here will override the alarm configuration at the deployment group level. Consider overriding the
         * alarm configuration if you have set up alarms at the deployment group level that are causing deployment
         * failures. In this case, you would call <code>CreateDeployment</code> to create a new deployment that uses a
         * previous application revision that is known to work, and set its alarm configuration to turn off alarm
         * polling. Turning off alarm polling ensures that the new deployment proceeds without being blocked by the
         * alarm that was generated by the previous, failed, deployment.
         * </p>
         * <note>
         * <p>
         * If you specify an <code>overrideAlarmConfiguration</code>, you need the <code>UpdateDeploymentGroup</code>
         * IAM permission when calling <code>CreateDeployment</code>.
         * </p>
         * </note>
         * 
         * @param overrideAlarmConfiguration
         *        Allows you to specify information about alarms associated with a deployment. The alarm configuration
         *        that you specify here will override the alarm configuration at the deployment group level. Consider
         *        overriding the alarm configuration if you have set up alarms at the deployment group level that are
         *        causing deployment failures. In this case, you would call <code>CreateDeployment</code> to create a
         *        new deployment that uses a previous application revision that is known to work, and set its alarm
         *        configuration to turn off alarm polling. Turning off alarm polling ensures that the new deployment
         *        proceeds without being blocked by the alarm that was generated by the previous, failed,
         *        deployment.</p> <note>
         *        <p>
         *        If you specify an <code>overrideAlarmConfiguration</code>, you need the
         *        <code>UpdateDeploymentGroup</code> IAM permission when calling <code>CreateDeployment</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAlarmConfiguration(AlarmConfiguration overrideAlarmConfiguration);

        /**
         * <p>
         * Allows you to specify information about alarms associated with a deployment. The alarm configuration that you
         * specify here will override the alarm configuration at the deployment group level. Consider overriding the
         * alarm configuration if you have set up alarms at the deployment group level that are causing deployment
         * failures. In this case, you would call <code>CreateDeployment</code> to create a new deployment that uses a
         * previous application revision that is known to work, and set its alarm configuration to turn off alarm
         * polling. Turning off alarm polling ensures that the new deployment proceeds without being blocked by the
         * alarm that was generated by the previous, failed, deployment.
         * </p>
         * <note>
         * <p>
         * If you specify an <code>overrideAlarmConfiguration</code>, you need the <code>UpdateDeploymentGroup</code>
         * IAM permission when calling <code>CreateDeployment</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder}
         * avoiding the need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #overrideAlarmConfiguration(AlarmConfiguration)}.
         * 
         * @param overrideAlarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAlarmConfiguration(AlarmConfiguration)
         */
        default Builder overrideAlarmConfiguration(Consumer<AlarmConfiguration.Builder> overrideAlarmConfiguration) {
            return overrideAlarmConfiguration(AlarmConfiguration.builder().applyMutation(overrideAlarmConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeDeployRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String deploymentGroupName;

        private RevisionLocation revision;

        private String deploymentConfigName;

        private String description;

        private Boolean ignoreApplicationStopFailures;

        private TargetInstances targetInstances;

        private AutoRollbackConfiguration autoRollbackConfiguration;

        private Boolean updateOutdatedInstancesOnly;

        private String fileExistsBehavior;

        private AlarmConfiguration overrideAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            applicationName(model.applicationName);
            deploymentGroupName(model.deploymentGroupName);
            revision(model.revision);
            deploymentConfigName(model.deploymentConfigName);
            description(model.description);
            ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            targetInstances(model.targetInstances);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
            updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            fileExistsBehavior(model.fileExistsBehavior);
            overrideAlarmConfiguration(model.overrideAlarmConfiguration);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDeploymentGroupName() {
            return deploymentGroupName;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final String getDeploymentConfigName() {
            return deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return ignoreApplicationStopFailures;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return targetInstances != null ? targetInstances.toBuilder() : null;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return updateOutdatedInstancesOnly;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final String getFileExistsBehavior() {
            return fileExistsBehavior;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior == null ? null : fileExistsBehavior.toString());
            return this;
        }

        public final AlarmConfiguration.Builder getOverrideAlarmConfiguration() {
            return overrideAlarmConfiguration != null ? overrideAlarmConfiguration.toBuilder() : null;
        }

        public final void setOverrideAlarmConfiguration(AlarmConfiguration.BuilderImpl overrideAlarmConfiguration) {
            this.overrideAlarmConfiguration = overrideAlarmConfiguration != null ? overrideAlarmConfiguration.build() : null;
        }

        @Override
        public final Builder overrideAlarmConfiguration(AlarmConfiguration overrideAlarmConfiguration) {
            this.overrideAlarmConfiguration = overrideAlarmConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
