/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;

public class ListBranchesIterable
implements SdkIterable<ListBranchesResponse> {
    private final CodeCommitClient client;
    private final ListBranchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBranchesIterable(CodeCommitClient client, ListBranchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBranchesResponseFetcher();
    }

    public Iterator<ListBranchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> branches() {
        Function<ListBranchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.branches() != null) {
                return response.branches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBranchesResponseFetcher
    implements SyncPageFetcher<ListBranchesResponse> {
        private ListBranchesResponseFetcher() {
        }

        public boolean hasNextPage(ListBranchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBranchesResponse nextPage(ListBranchesResponse previousPage) {
            if (previousPage == null) {
                return ListBranchesIterable.this.client.listBranches(ListBranchesIterable.this.firstRequest);
            }
            return ListBranchesIterable.this.client.listBranches((ListBranchesRequest)((Object)ListBranchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

