/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;

public class DescribePullRequestEventsPublisher
implements SdkPublisher<DescribePullRequestEventsResponse> {
    private final CodeCommitAsyncClient client;
    private final DescribePullRequestEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePullRequestEventsPublisher(CodeCommitAsyncClient client, DescribePullRequestEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePullRequestEventsPublisher(CodeCommitAsyncClient client, DescribePullRequestEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePullRequestEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePullRequestEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribePullRequestEventsResponseFetcher
    implements AsyncPageFetcher<DescribePullRequestEventsResponse> {
        private DescribePullRequestEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePullRequestEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePullRequestEventsResponse> nextPage(DescribePullRequestEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribePullRequestEventsPublisher.this.client.describePullRequestEvents(DescribePullRequestEventsPublisher.this.firstRequest);
            }
            return DescribePullRequestEventsPublisher.this.client.describePullRequestEvents((DescribePullRequestEventsRequest)((Object)DescribePullRequestEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

