/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PullRequestEventType {
    PULL_REQUEST_CREATED("PULL_REQUEST_CREATED"),
    PULL_REQUEST_STATUS_CHANGED("PULL_REQUEST_STATUS_CHANGED"),
    PULL_REQUEST_SOURCE_REFERENCE_UPDATED("PULL_REQUEST_SOURCE_REFERENCE_UPDATED"),
    PULL_REQUEST_MERGE_STATE_CHANGED("PULL_REQUEST_MERGE_STATE_CHANGED"),
    PULL_REQUEST_APPROVAL_RULE_CREATED("PULL_REQUEST_APPROVAL_RULE_CREATED"),
    PULL_REQUEST_APPROVAL_RULE_UPDATED("PULL_REQUEST_APPROVAL_RULE_UPDATED"),
    PULL_REQUEST_APPROVAL_RULE_DELETED("PULL_REQUEST_APPROVAL_RULE_DELETED"),
    PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN("PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN"),
    PULL_REQUEST_APPROVAL_STATE_CHANGED("PULL_REQUEST_APPROVAL_STATE_CHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PullRequestEventType> VALUE_MAP;
    private final String value;

    private PullRequestEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PullRequestEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PullRequestEventType> knownValues() {
        EnumSet<PullRequestEventType> knownValues = EnumSet.allOf(PullRequestEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PullRequestEventType.class, PullRequestEventType::toString);
    }
}

