/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePullRequestApprovalRuleRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, CreatePullRequestApprovalRuleRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(CreatePullRequestApprovalRuleRequest.getter(CreatePullRequestApprovalRuleRequest::pullRequestId)).setter(CreatePullRequestApprovalRuleRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approvalRuleName").getter(CreatePullRequestApprovalRuleRequest.getter(CreatePullRequestApprovalRuleRequest::approvalRuleName)).setter(CreatePullRequestApprovalRuleRequest.setter(Builder::approvalRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()}).build();
    private static final SdkField<String> APPROVAL_RULE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approvalRuleContent").getter(CreatePullRequestApprovalRuleRequest.getter(CreatePullRequestApprovalRuleRequest::approvalRuleContent)).setter(CreatePullRequestApprovalRuleRequest.setter(Builder::approvalRuleContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, APPROVAL_RULE_NAME_FIELD, APPROVAL_RULE_CONTENT_FIELD));
    private final String pullRequestId;
    private final String approvalRuleName;
    private final String approvalRuleContent;

    private CreatePullRequestApprovalRuleRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.approvalRuleName = builder.approvalRuleName;
        this.approvalRuleContent = builder.approvalRuleContent;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final String approvalRuleName() {
        return this.approvalRuleName;
    }

    public final String approvalRuleContent() {
        return this.approvalRuleContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullRequestApprovalRuleRequest)) {
            return false;
        }
        CreatePullRequestApprovalRuleRequest other = (CreatePullRequestApprovalRuleRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.approvalRuleName(), other.approvalRuleName()) && Objects.equals(this.approvalRuleContent(), other.approvalRuleContent());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePullRequestApprovalRuleRequest").add("PullRequestId", (Object)this.pullRequestId()).add("ApprovalRuleName", (Object)this.approvalRuleName()).add("ApprovalRuleContent", (Object)this.approvalRuleContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "approvalRuleName": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleName()));
            }
            case "approvalRuleContent": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePullRequestApprovalRuleRequest, T> g) {
        return obj -> g.apply((CreatePullRequestApprovalRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String approvalRuleName;
        private String approvalRuleContent;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullRequestApprovalRuleRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.approvalRuleName(model.approvalRuleName);
            this.approvalRuleContent(model.approvalRuleContent);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getApprovalRuleName() {
            return this.approvalRuleName;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final String getApprovalRuleContent() {
            return this.approvalRuleContent;
        }

        public final void setApprovalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
        }

        @Override
        public final Builder approvalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullRequestApprovalRuleRequest build() {
            return new CreatePullRequestApprovalRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePullRequestApprovalRuleRequest> {
        public Builder pullRequestId(String var1);

        public Builder approvalRuleName(String var1);

        public Builder approvalRuleContent(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

