/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OrderEnum {
    ASCENDING("ascending"),
    DESCENDING("descending"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OrderEnum> VALUE_MAP;
    private final String value;

    private OrderEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderEnum> knownValues() {
        EnumSet<OrderEnum> knownValues = EnumSet.allOf(OrderEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OrderEnum.class, OrderEnum::toString);
    }
}

