/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;

public class GetMergeConflictsPublisher
implements SdkPublisher<GetMergeConflictsResponse> {
    private final CodeCommitAsyncClient client;
    private final GetMergeConflictsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMergeConflictsPublisher(CodeCommitAsyncClient client, GetMergeConflictsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMergeConflictsPublisher(CodeCommitAsyncClient client, GetMergeConflictsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMergeConflictsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMergeConflictsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetMergeConflictsResponseFetcher
    implements AsyncPageFetcher<GetMergeConflictsResponse> {
        private GetMergeConflictsResponseFetcher() {
        }

        public boolean hasNextPage(GetMergeConflictsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMergeConflictsResponse> nextPage(GetMergeConflictsResponse previousPage) {
            if (previousPage == null) {
                return GetMergeConflictsPublisher.this.client.getMergeConflicts(GetMergeConflictsPublisher.this.firstRequest);
            }
            return GetMergeConflictsPublisher.this.client.getMergeConflicts((GetMergeConflictsRequest)((Object)GetMergeConflictsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

