/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBranchRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, CreateBranchRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(CreateBranchRequest.getter(CreateBranchRequest::repositoryName)).setter(CreateBranchRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchName").getter(CreateBranchRequest.getter(CreateBranchRequest::branchName)).setter(CreateBranchRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchName").build()}).build();
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(CreateBranchRequest.getter(CreateBranchRequest::commitId)).setter(CreateBranchRequest.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BRANCH_NAME_FIELD, COMMIT_ID_FIELD));
    private final String repositoryName;
    private final String branchName;
    private final String commitId;

    private CreateBranchRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.branchName = builder.branchName;
        this.commitId = builder.commitId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String branchName() {
        return this.branchName;
    }

    public final String commitId() {
        return this.commitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBranchRequest)) {
            return false;
        }
        CreateBranchRequest other = (CreateBranchRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.branchName(), other.branchName()) && Objects.equals(this.commitId(), other.commitId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBranchRequest").add("RepositoryName", (Object)this.repositoryName()).add("BranchName", (Object)this.branchName()).add("CommitId", (Object)this.commitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBranchRequest, T> g) {
        return obj -> g.apply((CreateBranchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String branchName;
        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBranchRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.branchName(model.branchName);
            this.commitId(model.commitId);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        @Transient
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        @Transient
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBranchRequest build() {
            return new CreateBranchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBranchRequest> {
        public Builder repositoryName(String var1);

        public Builder branchName(String var1);

        public Builder commitId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

