/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsError;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsErrorsListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.Commit;
import software.amazon.awssdk.services.codecommit.model.CommitObjectsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCommitsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, BatchGetCommitsResponse> {
    private static final SdkField<List<Commit>> COMMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commits").getter(BatchGetCommitsResponse.getter(BatchGetCommitsResponse::commits)).setter(BatchGetCommitsResponse.setter(Builder::commits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Commit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetCommitsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetCommitsResponse.getter(BatchGetCommitsResponse::errors)).setter(BatchGetCommitsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetCommitsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITS_FIELD, ERRORS_FIELD));
    private final List<Commit> commits;
    private final List<BatchGetCommitsError> errors;

    private BatchGetCommitsResponse(BuilderImpl builder) {
        super(builder);
        this.commits = builder.commits;
        this.errors = builder.errors;
    }

    public final boolean hasCommits() {
        return this.commits != null && !(this.commits instanceof SdkAutoConstructList);
    }

    public final List<Commit> commits() {
        return this.commits;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetCommitsError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommits() ? this.commits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsResponse)) {
            return false;
        }
        BatchGetCommitsResponse other = (BatchGetCommitsResponse)((Object)obj);
        return this.hasCommits() == other.hasCommits() && Objects.equals(this.commits(), other.commits()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCommitsResponse").add("Commits", this.hasCommits() ? this.commits() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commits": {
                return Optional.ofNullable(clazz.cast(this.commits()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommitsResponse, T> g) {
        return obj -> g.apply((BatchGetCommitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<Commit> commits = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetCommitsError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommitsResponse model) {
            super(model);
            this.commits(model.commits);
            this.errors(model.errors);
        }

        public final List<Commit.Builder> getCommits() {
            List<Commit.Builder> result = CommitObjectsListCopier.copyToBuilder(this.commits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommits(Collection<Commit.BuilderImpl> commits) {
            this.commits = CommitObjectsListCopier.copyFromBuilder(commits);
        }

        @Override
        @Transient
        public final Builder commits(Collection<Commit> commits) {
            this.commits = CommitObjectsListCopier.copy(commits);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder commits(Commit ... commits) {
            this.commits(Arrays.asList(commits));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder commits(Consumer<Commit.Builder> ... commits) {
            this.commits(Stream.of(commits).map(c -> (Commit)((Commit.Builder)Commit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetCommitsError.Builder> getErrors() {
            List<BatchGetCommitsError.Builder> result = BatchGetCommitsErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetCommitsError.BuilderImpl> errors) {
            this.errors = BatchGetCommitsErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<BatchGetCommitsError> errors) {
            this.errors = BatchGetCommitsErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(BatchGetCommitsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetCommitsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetCommitsError)((BatchGetCommitsError.Builder)BatchGetCommitsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCommitsResponse build() {
            return new BatchGetCommitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCommitsResponse> {
        public Builder commits(Collection<Commit> var1);

        public Builder commits(Commit ... var1);

        public Builder commits(Consumer<Commit.Builder> ... var1);

        public Builder errors(Collection<BatchGetCommitsError> var1);

        public Builder errors(BatchGetCommitsError ... var1);

        public Builder errors(Consumer<BatchGetCommitsError.Builder> ... var1);
    }
}

