/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a test report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestReportSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestReportSummary.Builder, TestReportSummary> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(TestReportSummary::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Map<String, Integer>> STATUS_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("statusCounts")
            .getter(getter(TestReportSummary::statusCounts))
            .setter(setter(Builder::statusCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> DURATION_IN_NANO_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationInNanoSeconds").getter(getter(TestReportSummary::durationInNanoSeconds))
            .setter(setter(Builder::durationInNanoSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInNanoSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD,
            STATUS_COUNTS_FIELD, DURATION_IN_NANO_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer total;

    private final Map<String, Integer> statusCounts;

    private final Long durationInNanoSeconds;

    private TestReportSummary(BuilderImpl builder) {
        this.total = builder.total;
        this.statusCounts = builder.statusCounts;
        this.durationInNanoSeconds = builder.durationInNanoSeconds;
    }

    /**
     * <p>
     * The number of test cases in this <code>TestReportSummary</code>. The total includes truncated test cases.
     * </p>
     * 
     * @return The number of test cases in this <code>TestReportSummary</code>. The total includes truncated test cases.
     */
    public final Integer total() {
        return total;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusCounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusCounts() {
        return statusCounts != null && !(statusCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains the number of each type of status returned by the test results in this
     * <code>TestReportSummary</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusCounts} method.
     * </p>
     * 
     * @return A map that contains the number of each type of status returned by the test results in this
     *         <code>TestReportSummary</code>.
     */
    public final Map<String, Integer> statusCounts() {
        return statusCounts;
    }

    /**
     * <p>
     * The number of nanoseconds it took to run all of the test cases in this report.
     * </p>
     * 
     * @return The number of nanoseconds it took to run all of the test cases in this report.
     */
    public final Long durationInNanoSeconds() {
        return durationInNanoSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusCounts() ? statusCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(durationInNanoSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestReportSummary)) {
            return false;
        }
        TestReportSummary other = (TestReportSummary) obj;
        return Objects.equals(total(), other.total()) && hasStatusCounts() == other.hasStatusCounts()
                && Objects.equals(statusCounts(), other.statusCounts())
                && Objects.equals(durationInNanoSeconds(), other.durationInNanoSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestReportSummary").add("Total", total())
                .add("StatusCounts", hasStatusCounts() ? statusCounts() : null)
                .add("DurationInNanoSeconds", durationInNanoSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "statusCounts":
            return Optional.ofNullable(clazz.cast(statusCounts()));
        case "durationInNanoSeconds":
            return Optional.ofNullable(clazz.cast(durationInNanoSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestReportSummary, T> g) {
        return obj -> g.apply((TestReportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestReportSummary> {
        /**
         * <p>
         * The number of test cases in this <code>TestReportSummary</code>. The total includes truncated test cases.
         * </p>
         * 
         * @param total
         *        The number of test cases in this <code>TestReportSummary</code>. The total includes truncated test
         *        cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);

        /**
         * <p>
         * A map that contains the number of each type of status returned by the test results in this
         * <code>TestReportSummary</code>.
         * </p>
         * 
         * @param statusCounts
         *        A map that contains the number of each type of status returned by the test results in this
         *        <code>TestReportSummary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCounts(Map<String, Integer> statusCounts);

        /**
         * <p>
         * The number of nanoseconds it took to run all of the test cases in this report.
         * </p>
         * 
         * @param durationInNanoSeconds
         *        The number of nanoseconds it took to run all of the test cases in this report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInNanoSeconds(Long durationInNanoSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer total;

        private Map<String, Integer> statusCounts = DefaultSdkAutoConstructMap.getInstance();

        private Long durationInNanoSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestReportSummary model) {
            total(model.total);
            statusCounts(model.statusCounts);
            durationInNanoSeconds(model.durationInNanoSeconds);
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Map<String, Integer> getStatusCounts() {
            if (statusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return statusCounts;
        }

        public final void setStatusCounts(Map<String, Integer> statusCounts) {
            this.statusCounts = ReportStatusCountsCopier.copy(statusCounts);
        }

        @Override
        public final Builder statusCounts(Map<String, Integer> statusCounts) {
            this.statusCounts = ReportStatusCountsCopier.copy(statusCounts);
            return this;
        }

        public final Long getDurationInNanoSeconds() {
            return durationInNanoSeconds;
        }

        public final void setDurationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
        }

        @Override
        public final Builder durationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
            return this;
        }

        @Override
        public TestReportSummary build() {
            return new TestReportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
