/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportsForReportGroupRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ListReportsForReportGroupRequest.Builder, ListReportsForReportGroupRequest> {
    private static final SdkField<String> REPORT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportGroupArn").getter(getter(ListReportsForReportGroupRequest::reportGroupArn))
            .setter(setter(Builder::reportGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListReportsForReportGroupRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListReportsForReportGroupRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListReportsForReportGroupRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<ReportFilter> FILTER_FIELD = SdkField.<ReportFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ListReportsForReportGroupRequest::filter)).setter(setter(Builder::filter))
            .constructor(ReportFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_ARN_FIELD,
            NEXT_TOKEN_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD));

    private final String reportGroupArn;

    private final String nextToken;

    private final String sortOrder;

    private final Integer maxResults;

    private final ReportFilter filter;

    private ListReportsForReportGroupRequest(BuilderImpl builder) {
        super(builder);
        this.reportGroupArn = builder.reportGroupArn;
        this.nextToken = builder.nextToken;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The ARN of the report group for which you want to return report ARNs.
     * </p>
     * 
     * @return The ARN of the report group for which you want to return report ARNs.
     */
    public final String reportGroupArn() {
        return reportGroupArn;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Use to specify whether the results are returned in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Use to specify whether the results are returned in ascending or descending order.
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * Use to specify whether the results are returned in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Use to specify whether the results are returned in ascending or descending order.
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to
     * iterate pages in the list of returned <code>Report</code> objects. The default value is 100.
     * </p>
     * 
     * @return The maximum number of paginated reports in this report group returned per response. Use
     *         <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default
     *         value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A <code>ReportFilter</code> object used to filter the returned reports.
     * </p>
     * 
     * @return A <code>ReportFilter</code> object used to filter the returned reports.
     */
    public final ReportFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportsForReportGroupRequest)) {
            return false;
        }
        ListReportsForReportGroupRequest other = (ListReportsForReportGroupRequest) obj;
        return Objects.equals(reportGroupArn(), other.reportGroupArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportsForReportGroupRequest").add("ReportGroupArn", reportGroupArn())
                .add("NextToken", nextToken()).add("SortOrder", sortOrderAsString()).add("MaxResults", maxResults())
                .add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportGroupArn":
            return Optional.ofNullable(clazz.cast(reportGroupArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportsForReportGroupRequest, T> g) {
        return obj -> g.apply((ListReportsForReportGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListReportsForReportGroupRequest> {
        /**
         * <p>
         * The ARN of the report group for which you want to return report ARNs.
         * </p>
         * 
         * @param reportGroupArn
         *        The ARN of the report group for which you want to return report ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGroupArn(String reportGroupArn);

        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Use to specify whether the results are returned in ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Use to specify whether the results are returned in ascending or descending order.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Use to specify whether the results are returned in ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Use to specify whether the results are returned in ascending or descending order.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * The maximum number of paginated reports in this report group returned per response. Use
         * <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default
         * value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of paginated reports in this report group returned per response. Use
         *        <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The
         *        default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A <code>ReportFilter</code> object used to filter the returned reports.
         * </p>
         * 
         * @param filter
         *        A <code>ReportFilter</code> object used to filter the returned reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ReportFilter filter);

        /**
         * <p>
         * A <code>ReportFilter</code> object used to filter the returned reports.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportFilter.Builder} avoiding the need
         * to create one manually via {@link ReportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(ReportFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ReportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ReportFilter)
         */
        default Builder filter(Consumer<ReportFilter.Builder> filter) {
            return filter(ReportFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String reportGroupArn;

        private String nextToken;

        private String sortOrder;

        private Integer maxResults;

        private ReportFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportsForReportGroupRequest model) {
            super(model);
            reportGroupArn(model.reportGroupArn);
            nextToken(model.nextToken);
            sortOrder(model.sortOrder);
            maxResults(model.maxResults);
            filter(model.filter);
        }

        public final String getReportGroupArn() {
            return reportGroupArn;
        }

        public final void setReportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
        }

        @Override
        public final Builder reportGroupArn(String reportGroupArn) {
            this.reportGroupArn = reportGroupArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ReportFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ReportFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ReportFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReportsForReportGroupRequest build() {
            return new ListReportsForReportGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
